
// Note: miniaudio is much more bloated than I would prefer it to be and it slows down this project's compile time a lot. There's ways to disable some unneeded features from it to make it slightly leaner, or you could compile it into a separate file so you don't need to re-compile it every time, but I'll leave it like this for now.
#define MINIAUDIO_IMPLEMENTATION
#include "miniaudio-master/miniaudio.h"

// Types.

	struct Sound {
		int index;
		int duplicates; // See load_sound() for an explanation.
		ma_sound* sounds;
	};

// Globals.

	ma_engine sound_engine = {0};
	
	Sound music_vibes = {0};
	
	Sound sound_shooting = {0};
	Sound sound_strong_shooting = {0};
	Sound sound_bullet_collide = {0};
	Sound sound_explode = {0};

// Functions.

	int init_audio () {
		ma_result result = ma_engine_init(NULL, &sound_engine);
		if (result != MA_SUCCESS) {
			printf("ma_engine_init failed!\n");
			return 1;
		}
		return 0;
	}
	int load_sound_from_file (Sound* sound, char* path, float volume, bool loop, int duplicates) {
		Sound newsound = {
			.duplicates = duplicates,
			.sounds = malloc(duplicates*sizeof(ma_sound)),
		};
		
		// Miniaudio is a bit annoying because it cannot play the same sound multiple times at the same time, you need to create duplicates of it and play different instances of it. We'll just allocate an array of duplicates and play them in a "ring buffer" (see play_sound()). The amount of times we can play this sound simultaneously is limited by the number of duplicates.
		// I don't know if this is how you're supposed to use minisound, but the SDL library seems to have similar limitations so maybe this is just how audio APIs work..?
		for (int i=0; i<duplicates; i++) {
			ma_result result = 0;
			
			ma_sound* selected_sound = newsound.sounds + i;
			
			// The first instance is loaded from a file, and the other ones are copied from the first one.
			if (i == 0) result = ma_sound_init_from_file(&sound_engine, path, 0, NULL, NULL, selected_sound);
			else        result = ma_sound_init_copy(&sound_engine, newsound.sounds+0, 0, NULL, selected_sound);
			
			if (result != MA_SUCCESS) {
				printf("Failed to create sound for (%s)!\n", path);
				free(newsound.sounds);
				return 1;
			}
			ma_sound_set_volume(selected_sound, volume);
			if (loop) ma_sound_set_looping(selected_sound, true); // Make this sound loop. Use this setting for background music.
		}
		
		*sound = newsound;
		return 0;
	}
	void play_sound (Sound* sound) {
		// Select whatever sound is at the current position, and then restart and play it.
		ma_sound* selected_sound = sound->sounds + sound->index;
		
		ma_sound_seek_to_pcm_frame(selected_sound, 0); // Restart.
		ma_sound_start(selected_sound);
		
		// This is how you use a "ring buffer": you keep moving forward, and when you reach the end, you jump back to the start and start re-using the previous items.
		sound->index ++;
		if (sound->index == sound->duplicates) sound->index = 0;
	}
