
// Type declarations.

	typedef  unsigned char  u8;
	
	typedef  struct Pixel  Pixel;
	typedef  struct Image  Image;

// Function declarations.

	Pixel get_rgb (u8 r, u8 g, u8 b);
	Pixel get_rgba (u8 r, u8 g, u8 b, u8 a);
	Pixel get_bgr (u8 r, u8 g, u8 b);
	Pixel get_bgra (u8 r, u8 g, u8 b, u8 a);
	
	int create_image (Image* image, int width, int height);
	int load_image_from_file (Image* image, char* path);
	void resize_image (Image* image, int width, int height);
	
	void fill_image_with_color (Image* target, Pixel color);
	void draw_rect (Image* target, int xstart, int ystart, int width, int height, Pixel color);
	void draw_image (Image* target, Image* source, int target_x, int target_y);
