@ECHO OFF

rem settings

	set build_release=1
	set build_dev=2
	set build_debug=3
	set build_type=build_release
	
	set exename=zzzbanner
	set releasepath=release
	set codepath=code
	set gcc=gcc
	set gdb=gdb
	
	set console_on_release_build=1

rem config

	rem note: -pedantic is desireable in theory, but it forbids "nested functions", which I assume means a function that uses variables from the parent scope. I use these effectively as macros so fuck you.
	rem strict-prototypes = functions must define something in the arguments, if it takes no arguments then it must have "void" in it. There's an edge case that's still a bit wrong though: if the function is declared earlier with "void", it can still be defined with an empty arguments list. The function won't accept arguments though [it would without strict-prototypes], it just looks wrong.
	rem return-type warns if functions don't return values correctly
	rem inline should warn when an inline function cannot be inlined for some reason, there's some kinds of things that make it unsuitable for inlining
	rem fallthrough requires the usage of __attribute__ fallthrough for switch cases. This stops you from accidentally falling through switch cases.
	rem pointer-arith = forbids offsetting void pointers which is fucking gay and retarded.
	rem dangling-else = complains about single line'd if/else chains because they're """suspicious""".
	rem format = complains about incompatible printf inputs, good in theory but downright broken in practice. It doesn't recognize %lli, and who cares what specific int type some fucking Windows "WPARAM" value is.
	rem unused-function, unused-value, unused-variable, unused-but-set-variable, unused-local-typedefs = complains about things that are defined but not used afterwards, i.e. makes development a pain in the fucking ass.
	rem incompatible-pointer-types = makes function pointers a pain in the ass since you won't be able to auto-cast "void" function pointers. Supposedly function pointers aren't always the same size so maybe this shouldn't be disabled.
	set errorflags=-Werror -Wall -Wstrict-prototypes -Wreturn-type -Winline -Wimplicit-fallthrough   -Wno-format -Wno-pointer-arith -Wno-dangling-else   -Wno-unused-function -Wno-unused-value -Wno-unused-variable -Wno-unused-but-set-variable -Wno-unused-local-typedefs

	set compile=%gcc% -m64
	set link=%gcc%

	IF %build_type%==build_release (
		set compile=%compile% -DBUILD_RELEASE -O3
		rem set compile=%compile% -DBUILD_RELEASE -Os
		rem -Wl,--gc-sections removes unused symbols or something from the program
		rem -mconsole and -mwindows decides what kind of executable to make, Windows has 2 different kinds, -mconsole is default. -mwindows will prevent console from opening.
		rem -s removes some symbol information that reduces the filesize by a lot
		IF %console_on_release_build%==1 (
			set link=%link% -s -Wl,--gc-sections
		) ELSE (
			set link=%link% -s -Wl,--gc-sections -mwindows
		)
	) ELSE (
		set link=%link% -Wl,--gc-sections
		set compile=%compile% -DBUILD_DEV
		IF %build_type%==build_debug (
			rem -Og enables optimizations that do not interfere with debugging
			set compile=%compile% -DBUILD_DEBUG -Og
			rem -g adds debug info for debuggers		-ggdb is an extended version of -g for gdb?
			set compile=%compile% -ggdb
			set exename=%exename%_DEBUG
		) ELSE (
			set exename=%exename%_DEV
		)
	)

	set link=%link% "main.o" "myicon.res" -lgdi32 -o "%releasepath%\%exename%.exe"
	
	set compile=%compile% %errorflags% -DOS_WINDOWS -c "%codepath%\main.c" -o "main.o"
	
	IF %build_type%==build_debug (
		set start=%gdb% --batch -ex run -ex bt "%releasepath%\%exename%.exe"
	) ELSE (
		set start="%releasepath%\%exename%.exe"
	)
	
rem build

	echo ---Build--- Navigating... cd "%~dp0"
	cd "%~dp0"

	IF %build_type%==build_release (
		echo ---Build--- Making icon resource... windres "myicon.rc" -O coff -o "myicon.res"
		windres "myicon.rc" -O coff -o "myicon.res"
	)

	echo ---Build--- Compiling... %compile%
	%compile% || pause

	echo ---Build--- Linking... %link%
	%link% || pause

	DEL "main.o"

	echo ---Build--- Running executable... %start%
	echo.
	echo.
	%start%
	echo.
	echo.
	echo ---Build--- Done.

rem gcc options http://tigcc.ticalc.org/doc/comopts.html
rem %cd% = working directory    %~dp0 = directory of this file   %1 = first argument sent to this file

rem basically, in debug builds we want to read the debugger output, but in normal builds we don't give a fuck
IF NOT %build_type%==build_debug (
	exit
)