#ifndef LIB_BASEDEFS_H
#define LIB_BASEDEFS_H 1
#pragma once

#ifndef BUILD_DEV
	#define BUILD_DEV 0
#endif
#ifndef BUILD_RELEASE
	#define BUILD_RELEASE 0
#endif
#ifndef BUILD_DEBUG
	#define BUILD_DEBUG 0
#endif

// types

	#include <stdint.h>
	// integer the same size as int
	typedef intptr_t Pointer_sized_int;
	typedef uintptr_t Pointer_sized_uint;
	// unsigned
	typedef uint8_t u8;
	typedef uint16_t u16;
	typedef uint32_t u32;
	typedef uint64_t u64;
	// signed
	typedef int8_t i8;
	typedef int16_t i16;
	typedef int32_t i32;
	typedef int64_t i64;
	// floats
	typedef float f32;
	typedef double f64;
	// bool
	typedef _Bool bool;
	#define true 1
	#define false 0
	// lengths
	#define U8_MAX   255
	#define I8_MAX   127
	#define I8_MIN  -128
	#define U16_MAX  65535
	#define I16_MAX  32767
	#define I16_MIN -32768
	#define U32_MAX  4294967295
	#define I32_MAX  2147483647
	#define I32_MIN -2147483648
	// #define U64_MAX  18446744073709551615 // this refuses to compile because C is a gay retard language
	#define U64_MAX  0xFFFFFFFFFFFFFFFF
	#define I64_MAX  9223372036854775807
	#define I64_MIN -9223372036854775808

// fun

	#include <string.h> // required for strlen, it is impossible to implement it yourself
	#include <stdio.h> // I don't want this
	#include <stdlib.h> // ugh MOM
	
	#define mem_copy_to(to, amount, from) memcpy(to, from, amount)
	#define mem_move_to(to, amount, from) memmove(to, from, amount)
	// #define mem_zero(amount, to, byte) memset(to, byte, from)
	#define pause() os_sleep_ms(1000*60*60*12)
	
	static inline u32 nearest_power_of_two_not_lower_u32 (u32 x) {
		if (x == 0 || x == 1) return 1;
		x -= 1;
		x |= x>>1;
		x |= x>>2;
		x |= x>>4;
		x |= x>>8;
		x |= x>>16;
		return x+1;
	}
	static inline u64 nearest_power_of_two_not_lower_u64 (u64 x) {
		if (x == 0 || x == 1) return 1;
		x -= 1;
		x |= x>>1;
		x |= x>>2;
		x |= x>>4;
		x |= x>>8;
		x |= x>>16;
		x |= x>>32;
		return x+1;
	}
	
	#define BRESENHAM_START(x0, y0, x1, y1) { \
		i32 bresenham_x = x0; \
		i32 bresenham_y = y0; \
		i32 _brex = x1; \
		i32 _brey = y1; \
		i32 _dx = abs(_brex - bresenham_x); \
		i32 _dy = abs(_brey - bresenham_y); \
		i32 _sx = (bresenham_x < _brex) ? 1 : -1; \
		i32 _sy = (bresenham_y < _brey) ? 1 : -1; \
		i32 _diff = (_dx - _dy); \
		i32 _diff2; \
		while (TRUE) {
	
	#define BRESENHAM_END \
			if ((bresenham_x==_brex) && (bresenham_y==_brey)) break; \
			_diff2 = _diff*2; \
			if (_diff2 > -_dy){ \
				_diff -= _dy; \
				bresenham_x  += _sx; \
			} \
			if (_diff2 < _dx){ \
				_diff += _dx; \
				bresenham_y  += _sy; \
			} \
		} \
	}
	
	#define STRING_FROM_PRINT(n, str, ...) \
		char* n = NULL; \
		int n##_length = snprintf(NULL, 0, str, __VA_ARGS__); \
		n = alloca(n##_length+1); \
		snprintf(n, n##_length+1, str, __VA_ARGS__); \
		n[n##_length] = 0;
	
	#define STRING_FROM_PRINT_N(n, maxlen, str, ...) \
		char n [maxlen+1]; \
		int n##_length = snprintf(n, maxlen+1, str, __VA_ARGS__); \
		n[maxlen] = 0;
	
	#define STRING_FROM_STRINGS(n, ...) \
		String n = {0}; \
		{ \
			String item[] = { __VA_ARGS__, ((String){0}) }; \
			int i = 0; \
			while (item[i].data) { \
				n.length += item[i].length; \
				i ++; \
			} \
		} \
		n.data = alloca(n.length+1); \
		{ \
			String item[] = { __VA_ARGS__, ((String){0}) }; \
			int pos = 0; \
			int i = 0; \
			while (item[i].data) { \
				mem_copy_to(n.data+pos, item[i].length, item[i].data); \
				pos += item[i].length; \
				i ++; \
			} \
			n.data[n.length] = 0; \
		}

// include guard
#endif