#ifndef LIB_VEC_C
#define LIB_VEC_C 1
#pragma once

// types

	#pragma pack(push, 1)

	typedef struct { union { i8 x;  i8 w;  }; union { i8 y;  i8 h;  }; } Vec2_i8;
	typedef struct { union { i16 x; i16 w; }; union { i16 y; i16 h; }; } Vec2_i16;
	typedef struct { union { i32 x; i32 w; }; union { i32 y; i32 h; }; } Vec2_i32;
	typedef struct { union { i64 x; i64 w; }; union { i64 y; i64 h; }; } Vec2_i64;
	
	typedef struct { union { u8 x;  u8 w;  }; union { u8 y;  u8 h;  }; } Vec2_u8;
	typedef struct { union { u16 x; u16 w; }; union { u16 y; u16 h; }; } Vec2_u16;
	typedef struct { union { u32 x; u32 w; }; union { u32 y; u32 h; }; } Vec2_u32;
	typedef struct { union { u64 x; u64 w; }; union { u64 y; u64 h; }; } Vec2_u64;
	
	typedef struct { union { f32 x; f32 w; }; union { f32 y; f32 h; }; } Vec2_f32;
	typedef struct { union { f64 x; f64 w; }; union { f64 y; f64 h; }; } Vec2_f64;
	
	#pragma pack(pop)

// convert functions

	static inline Vec2_i8  vec2_i8  (i8 x,  i8 y)  { return (Vec2_i8){.x=x, .y=y}; }
	static inline Vec2_i16 vec2_i16 (i16 x, i16 y) { return (Vec2_i16){.x=x, .y=y}; }
	static inline Vec2_i32 vec2_i32 (i32 x, i32 y) { return (Vec2_i32){.x=x, .y=y}; }
	static inline Vec2_i64 vec2_i64 (i64 x, i64 y) { return (Vec2_i64){.x=x, .y=y}; }
	
	static inline Vec2_u8  vec2_u8  (u8 x,  u8 y)  { return (Vec2_u8){.x=x, .y=y}; }
	static inline Vec2_u16 vec2_u16 (u16 x, u16 y) { return (Vec2_u16){.x=x, .y=y}; }
	static inline Vec2_u32 vec2_u32 (u32 x, u32 y) { return (Vec2_u32){.x=x, .y=y}; }
	static inline Vec2_u64 vec2_u64 (u64 x, u64 y) { return (Vec2_u64){.x=x, .y=y}; }
	
	static inline Vec2_f32 vec2_f32 (f32 x, f32 y) { return (Vec2_f32){.x=x, .y=y}; }
	static inline Vec2_f64 vec2_f64 (f64 x, f64 y) { return (Vec2_f64){.x=x, .y=y}; }

// shorter names

	typedef Vec2_i32 Vec2i;
	typedef Vec2_f32 Vec2f;
	#define vec2i vec2_i32
	#define vec2f vec2_f32

// include guard
#endif