/*
	https://docs.microsoft.com/en-us/windows/win32/debug/system-error-codes--0-499-
*/

	/*typedef u16 OS_WINDOW_FLAG; enum {
		OS_WINDOW_OPEN = BIT1,
		OS_WINDOW_HAS_FOCUS = BIT2,
		OS_WINDOW_MINIMIZED = BIT3,
		OS_WINDOW_FULLSCREEN = BIT4,
		OS_WINDOW_GL = BIT5,
		OS_WINDOW_BORDERLESS = BIT6,
		OS_WINDOW_NO_RESIZE = BIT7,
		OS_WINDOW_INVISIBLE = BIT8,
		OS_WINDOW_TRANSPARENT_PIXELS = BIT9,
		OS_WINDOW_ALWAYS_ON_TOP = BIT10,
		OS_WINDOW_VISIBLE_ON_TASKBAR = BIT11,
		OS_WINDOW_CURSOR_IS_VISIBLE = BIT12,
		OS_WINDOW_CLICK_THROUGH = BIT13,
		// BIT13
		// BIT14
		// BIT15,
		// BIT16,
	};
	
	typedef struct Os_window Os_window;
	struct Os_window {
		OS_WINDOW_FLAG flags;
		Bounds2i inner_bounds;
		Bounds2i outer_bounds;
		
		HWND win_window_handle;
		HDC	win_device_context; // used for drawing onto the window and stuff
		bool win_capture_raw_mouse : 1;
		bool win_capture_raw_mouse_active : 1;
		bool win_capture_raw_mouse_initialized : 1;
		Image image; // for software rendering
		#if ENABLED_GL
			HGLRC win_render_context; // for opengl
		#endif
	};
	
	typedef u8 OS_EVENT; enum {
		OS_EVENT_NONE,
		
		OS_EVENT_MOUSE_MOVE,
		OS_EVENT_MOUSE_BUTTON,
		OS_EVENT_MOUSE_WHEEL,
		OS_EVENT_KEY,
		OS_EVENT_KEY_REPEAT,
		OS_EVENT_TEXT, // text input, as in actual character was input into the program, is not correlated with keyboard keys
		OS_EVENT_WINDOW_MOVE,
		OS_EVENT_WINDOW_RESIZE,
		OS_EVENT_WINDOW_FOCUS_CHANGE,
		OS_EVENT_WINDOW_FILE_DROP,
		OS_EVENT_WINDOW_CLOSED,
		OS_EVENT_WINDOW_WANTS_REDRAW,
	};
	typedef struct {
		OS_EVENT type;
		
		Os_window* window;
		union {
			struct {
				Vec2i pos;
				Vec2i offset;
			} mouse_move;
			struct {
				INPUT id;
				Vec2i pos;
				u8 state; // 0 = lifted, 1 = pressed, 2 = double click
			} mouse_button;
			struct {
				Vec2i pos;
				int offset;
			} mouse_wheel;
			struct {
				INPUT id;
				u8 state; // 0 = lifted, 1 = pressed, 2 = double click
			} key;
			struct {
				TEXTCHARACTER id;
			} text;
			struct {
				Vec2i pos;
			} window_move;
			struct {
				Vec2i size;
			} window_resize;
			struct { // whether window is active (i.e should receive keyboard input and such)
				bool focused;
			} window_focus_change;
			struct {
				Vec2i pos;
				char* pathlist; // note: make sure to copy the data away from here immediately, and don't free this data
				int file_count;
			} window_file_drop;
		};
	} Os_window_event;*/

// win

	#define INPUT WIN_INPUT
	// this causes Windows to use wide string functions, e.g. translating  'WNDCLASS'  to  'WNDCLASSW'  instead of  'WNDCLASSA'. I think you HAVE to define this since there's some secret values that you can't manually control (by using the *W functions/structs manually)
	#define UNICODE 1
	#define _UNICODE 1
	
	// #define WIN32_LEAN_AND_MEAN 1
	#include <windows.h>
	#include <commdlg.h> // some graphics shit
	#include <stdio.h> // for printf
	#include <shlobj.h> // some file selector shit
	#include <shellapi.h> // some file selector shit
	
	#undef INPUT

// multibyte string dickery because Windows uses wide char shit

	#define WSTR_FROM_MBSTR(name, mbstr) \
		int name##_mblength = _mbstrlen(mbstr); \
		int name##_size = MultiByteToWideChar(CP_UTF8, 0, mbstr, name##_mblength, NULL, 0)*2; \
		WCHAR name[name##_size+4]; \
		MultiByteToWideChar(CP_UTF8, 0, mbstr, name##_mblength, name, name##_size); \
		*(int*)(((char*)(name))+name##_size) = 0;

	#define MBSTR_FROM_WSTR(name, wideStr) \
		int name##_widelength = wcslen(wideStr); \
		int name##_size = WideCharToMultiByte(CP_UTF8, 0, wideStr, name##_widelength, NULL, 0, NULL, NULL); \
		char name[name##_size+1]; \
		WideCharToMultiByte(CP_UTF8, 0, wideStr, name##_widelength, name, name##_size+1, NULL, NULL); \
		*(name+name##_size) = 0;

// meme

	static inline int mem_free (void* mem) {
		return HeapFree(GetProcessHeap(), 0, mem);
	}
	static inline void* mem_alloc (u32 amount) {
		return HeapAlloc(GetProcessHeap(), 0, amount);
	}
	static inline void* mem_alloc_zeroed (u32 amount) {
		return HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, amount);
	}
	static inline void* mem_realloc (void* mem, u32 amount) {
		return HeapReAlloc(GetProcessHeap(), 0, mem, amount);
	}

// file system

	typedef struct {
		int size;
		void* data;
	} Os_file;
	
	static bool os_file_exists (char* filepath) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE filehandle = CreateFileW(wpath, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE|FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (filehandle == INVALID_HANDLE_VALUE) return false;
		
		CloseHandle(filehandle);
		return true;
	}
	static i64 os_get_file_size (char* filepath) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE filehandle = CreateFileW(wpath, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE|FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (filehandle == INVALID_HANDLE_VALUE) return -1;
		
		i64 filesize = -1;
		LARGE_INTEGER s;
		BOOL success = GetFileSizeEx(filehandle, &s);
		if (success) {
			filesize = s.QuadPart;
		}
		
		CloseHandle(filehandle);
		return filesize;
	}
	static int os_load_entire_file (char* filepath, Os_file* file) {
		// Note: Buffer should not already be allocated.
		// Note: The buffer will be null terminated so it can be read as C string. The .size property doesn't include null terminator.
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE filehandle = CreateFileW(wpath, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (filehandle == INVALID_HANDLE_VALUE) return 1;
		
		int error = 0;
		LARGE_INTEGER li;
		BOOL success = GetFileSizeEx(filehandle, &li);
		if (!success) {
			error = 2;
		}
		else {
			file->size = li.QuadPart;
			file->data = mem_alloc(file->size+64);// make sure there's a bit of extra padding in case you want to read this with u64 values or SIMD registers or as null terminated string or whatever.
			
			DWORD bytesread = 0;
			BOOL success = ReadFile(filehandle, file->data, file->size, &bytesread, NULL);
			// TODO? handle a situation where all bytes weren't read
			if (!success) {
				mem_free(file->data);
				error = 3;
			}
			// fill the remainder space with 0s
			for (int i=0; i<64; i++) {
				((char*)file->data)[file->size+i] = 0;
			}
		}
		
		CloseHandle(filehandle);
		return error;
	}
	static void os_free_file_data (Os_file* file) {
		if (file->data) mem_free(file->data);
		*file = (Os_file){0};
	}
	
	static int os_write_to_file (char* filepath, int datalength, void* data) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE filehandle = CreateFileW(wpath, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (filehandle == INVALID_HANDLE_VALUE) return 1;
		
		int error = 0;
		DWORD byteswritten = 0;
		BOOL success = WriteFile(filehandle, data, datalength, &byteswritten, NULL);
		// TODO? handle a situation where all bytes weren't written
		if (!success) {
			error = 2;
		}
		
		CloseHandle(filehandle);
		return error;
	}
	static int os_write_to_file_at (char* filepath, long pos, int datalength, void* data) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE filehandle = CreateFileW(wpath, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (filehandle == INVALID_HANDLE_VALUE) return 1;
		
		int error = 0;
		LARGE_INTEGER p = {.QuadPart=pos};
		BOOL success = SetFilePointerEx(filehandle, p, NULL, FILE_BEGIN);
		if (!success) {
			error = 2;
		}
		else {
			DWORD bytesWritten = 0;
			BOOL success = WriteFile(filehandle, data, datalength, &bytesWritten, NULL);
			// TODO: handle a situation where all bytes weren't written
			if (!success) {
				error = 3;
			}
		}
		
		CloseHandle(filehandle);
		return error;
	}
	
	static int os_delete_file (char* filepath) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		BOOL success = DeleteFileW(wpath);
		if (!success) {
			return 1;
		}
		return 0;
	}
	static int os_resize_file (char* filepath, i64 newSize) {
		WSTR_FROM_MBSTR(wpath, filepath);
		
		HANDLE file = CreateFileW(wpath, GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file == INVALID_HANDLE_VALUE) return 1;
		
		int error = 0;
		LARGE_INTEGER p = {.QuadPart=newSize};
		BOOL success = SetFilePointerEx(file, p, NULL, FILE_BEGIN);
		if (!success) {
			error = 2;
		}
		else {
			BOOL success = SetEndOfFile(file);
			if (!success) {
				error = 3;
			}
		}
		
		CloseHandle(file);
		return error;
	}
	static int os_rename_file (char* oldpath, char* newpath) {
		WSTR_FROM_MBSTR(wpathold, oldpath);
		WSTR_FROM_MBSTR(wpathnew, newpath);
		
		BOOL success = MoveFileW(wpathold, wpathnew);
		if (!success) {
			return 1;
		}
		return 0;
	}
	
	static bool os_folder_exists (char* path) {
		WSTR_FROM_MBSTR(folderpath, path);
		
		DWORD attribs = GetFileAttributesW(folderpath);
		if (attribs == INVALID_FILE_ATTRIBUTES) return false;
		return TRUE;
	}
	static int os_create_folder (char* path) {
		if (os_folder_exists(path)) return 0;
		
		WSTR_FROM_MBSTR(folderpath, path);
		
		BOOL success = CreateDirectoryW(folderpath, NULL);
		if (!success) return 1;
		return 0;
	}
	static int os_delete_folder (char* path) {
		if (!os_folder_exists(path)) return 0;
		
		WSTR_FROM_MBSTR(folderpath, path);
		
		BOOL success = RemoveDirectoryW(folderpath);
		if (!success) return 1;
		return 0;
	}
	
	// do NOT free the strings that these return
	static char* os_get_desktop_path (void) {
		static char* result = NULL;
		
		if (!result) {
			WCHAR wpath[MAX_PATH*4];
			BOOL success = SHGetSpecialFolderPathW(HWND_DESKTOP, wpath, CSIDL_DESKTOP, FALSE);
			if (!success) return NULL;
			
			MBSTR_FROM_WSTR(path, wpath);
			
			// replace gay windows path slashes
			for (int i=0; i<path_size; i++) {
				if (path[i] == '\\') path[i] = '/';
			}
			
			result = mem_alloc(path_size+1);
			mem_copy_to(result, path_size, path);
			result[path_size] = 0;
		}
		
		return result;
	}
	static char* os_get_program_path (void) {
		static char* result = NULL;
		
		if (!result) {
			WCHAR wpath[_MAX_PATH+1];
			DWORD success = GetModuleFileNameW(NULL, wpath, _MAX_PATH);
			if (!success) return NULL;
			
			MBSTR_FROM_WSTR(path, wpath);
			
			// replace gay windows path slashes
			for (int i=0; i<path_size; i++) {
				if (path[i] == '\\') path[i] = '/';
			}
			// remove executable name from the path
			while (path_size && path[path_size-1] != '/') {
				path_size --;
			}
			
			result = mem_alloc(path_size+1);
			mem_copy_to(result, path_size, path);
			result[path_size] = 0;
		}
		
		return result;
	}

// time

	u64 win_time_frequency = 0;
	
	static u64 os_highres_time_to_us (u64 time) {
		// this is apparently how you do the conversion, multiplication first to protect against loss of precision from the division.
		// Note: you maybe shouldn't use microsecond time as a counter since the precision is never perfect due to this division. The precision loss is in microseconds though, so maybe it's not a big deal unless you need actual time-of-day accurate timer.
		return (time * 1000000) / win_time_frequency;
	}
	static u64 os_get_current_highres_time (void) {
		LARGE_INTEGER win_time;
		QueryPerformanceCounter(&win_time);
		
		return win_time.QuadPart;
	}
	static u64 os_get_current_us_time (void) {
		LARGE_INTEGER win_time;
		QueryPerformanceCounter(&win_time);
		
		u64 res = ((u64)win_time.QuadPart * 1000000) / win_time_frequency;
		return res;
	}
	
	static void os_sleep_ms (u32 milliseconds) {
		SleepEx(milliseconds, TRUE);
	}

// window

	// typedef struct {int x;} Os_window;
	// void os_handle_window_events (void) {}
	// void os_window_display_image (Os_window* window, Image* image) {}
	// void os_window_init_software_graphics (Os_window* window) {}

// misc

	/*static int os_execute_console_command (String command, void(*callback)(Buffer output), bool show_cmd_window) {
		// https://docs.microsoft.com/en-us/windows/win32/api/processthreadsapi/ns-processthreadsapi-startupinfoa
		// TODO: this doesn't handle errors properly, the handles need to be closed and whatever
		WSTR_FROM_MBSTR(wCommand, command);
		
		if (callback) {
			HANDLE childProcess_STDIN_read = NULL;
			HANDLE childProcess_STDIN_write = NULL;
			HANDLE childProcess_STDOUT_read = NULL;
			HANDLE childProcess_STDOUT_write = NULL;
			
			// Set the bInheritHandle flag so pipe handles are inherited.
			SECURITY_ATTRIBUTES secAttribs = {
				.nLength = sizeof(SECURITY_ATTRIBUTES),
				.bInheritHandle = TRUE,
				.lpSecurityDescriptor = NULL,
			};

			// Create a pipe for the child process's STDOUT.
			if ( !CreatePipe(&childProcess_STDOUT_read, &childProcess_STDOUT_write, &secAttribs, 0) ) {
				printf("* NOTE * Failed CreatePipe\n");
				return 1;
			}
			// Ensure the read handle to the pipe for STDOUT is not inherited.
			if ( !SetHandleInformation(childProcess_STDOUT_read, HANDLE_FLAG_INHERIT, 0) ) {
				printf("* NOTE * Failed SetHandleInformation\n");
				return 1;
			}
			// Create a pipe for the child process's STDIN.
			if ( !CreatePipe(&childProcess_STDIN_read, &childProcess_STDIN_write, &secAttribs, 0) ) {
				printf("* NOTE * Failed CreatePipe\n");
				return 1;
			}
			// Ensure the write handle to the pipe for STDIN is not inherited.
			if ( !SetHandleInformation(childProcess_STDIN_write, HANDLE_FLAG_INHERIT, 0) ) {
				printf("* NOTE * Failed SetHandleInformation\n");
				return 1;
			}
			
			STARTUPINFOW startupInfo = {
				.cb = sizeof(STARTUPINFOW),
				.hStdError = childProcess_STDOUT_write,
				.hStdOutput = childProcess_STDOUT_write,
				.hStdInput = childProcess_STDIN_read,
				.dwFlags = STARTF_USESTDHANDLES,
			};
			PROCESS_INFORMATION processInfo = {0};
			
			DWORD dwCreationFlags = NORMAL_PRIORITY_CLASS;
			if (!show_cmd_window) dwCreationFlags |= CREATE_NO_WINDOW;
			
			BOOL result = CreateProcessW(
				NULL,				// LPCTSTR lpApplicationName
				wCommand,			// LPTSTR lpCommandLine
				NULL,				// process security attributes
				NULL,				// primary thread security attributes
				TRUE,				// handles are inherited
				dwCreationFlags,	// creation flags
				NULL,				// use parent's environment
				NULL,				// use parent's current directory
				&startupInfo,		// STARTUPINFO pointer
				&processInfo		// receives PROCESS_INFORMATION
			);
			if (!result) {
				int e = GetLastError();
				printf("* NOTE * Error starting process (with callback path)!, %i (", e);
				switch (e) {
					case ERROR_INVALID_NAME:   printf("ERROR_INVALID_NAME");   break;
					case ERROR_FILE_NOT_FOUND: printf("ERROR_FILE_NOT_FOUND"); break;
				}
				printf(")\n");
				printf("* command: (%.*s)\n", command.length,command.data);
				return 1;
			}
			
			// Close handles to the child process and its primary thread. Some applications might keep these handles to monitor the status of the child process, for example.
			CloseHandle(processInfo.hProcess);
			CloseHandle(processInfo.hThread);
			// Close handles to the stdin and stdout pipes no longer needed by the child process. If they are not explicitly closed, there is no way to recognize that the child process has ended.
			CloseHandle(childProcess_STDOUT_write);
			CloseHandle(childProcess_STDIN_read);
			
			const int BUFSIZE = 4096;
			DWORD bytesRead = 0;
			// DWORD bytesWritten = 0;
			// HANDLE hParentStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
			
			Buffer out = {.data=alloca(BUFSIZE)};
			
			while (1) {
				result = ReadFile( childProcess_STDOUT_read, out.data, BUFSIZE, &bytesRead, NULL);
				if ( !result || bytesRead == 0 ) break;
				out.size = bytesRead;
				callback(out);
				// result = WriteFile(hParentStdOut, buffer, bytesRead, &bytesWritten, NULL);
				// if (! result ) break;
			}
		}
		else {
			STARTUPINFOW startupInfo = {
				.cb = sizeof(STARTUPINFOW),
				// .lpReserved = NULL,
				// .lpDesktop,
				// .lpTitle = NULL, // window title
				// DWORD  dwX;
				// DWORD  dwY;
				// DWORD  dwXSize;
				// DWORD  dwYSize;
				// DWORD  dwXCountChars,
				// DWORD  dwYCountChars,
				// DWORD  dwFillAttribute,
				// .dwFlags = 0,
				// WORD   wShowWindow,
				// WORD   cbReserved2,
				// LPBYTE lpReserved2,
				// HANDLE hStdInput,
				// HANDLE hStdOutput,
				// HANDLE hStdError
			};
			PROCESS_INFORMATION processInfo = {0};
				// HANDLE hProcess; // process handle
				// HANDLE hThread; // process thread
				// DWORD  dwProcessId;
				// DWORD  dwThreadId;
			
			DWORD dwCreationFlags = NORMAL_PRIORITY_CLASS;
			if (!show_cmd_window) dwCreationFlags |= CREATE_NO_WINDOW;
			
			BOOL res = CreateProcessW(
				NULL, // LPCTSTR lpApplicationName
				wCommand, // LPTSTR lpCommandLine
				NULL, // LPSECURITY_ATTRIBUTES lpProcessAttributes,
				NULL, // LPSECURITY_ATTRIBUTES lpThreadAttributes,
				FALSE, // BOOL bInheritHandles,
				dwCreationFlags, // DWORD dwCreationFlags,
				NULL, // LPVOID lpEnvironment,
				NULL, // LPCSTR lpCurrentDirectory, // basically where the process is cd'd to
				&startupInfo, // LPSTARTUPINFOA lpStartupInfo,
				&processInfo // LPPROCESS_INFORMATION lpProcessInformation
			);
			if (!res) {
				int e = GetLastError();
				printf("* NOTE * Error starting process!!, %i (", e);
				switch (e) {
					case ERROR_INVALID_NAME:   printf("ERROR_INVALID_NAME");   break;
					case ERROR_FILE_NOT_FOUND: printf("ERROR_FILE_NOT_FOUND"); break;
				}
				printf(")\n");
				printf("* command: (%.*s)\n", command.length,command.data);
				return 1;
			}
		}
		
		return 0;
	}*/
	
	static void os_init (void) {
		// get CPU clock frequency
		LARGE_INTEGER tf;
		QueryPerformanceFrequency(&tf);
		win_time_frequency = tf.QuadPart;
	}
