
#include "plugin_base.h"
Plugin_api api = {0};
Plugin_file_format supported_formats [] = {
	{.ext=S("jxl")},
	{.ext=S("avif")},
	{.ext=S("webp")},
	{.ext=S("ico")},
	{.ext=S("ani")},
	{.ext=S("cur")},
	{.ext=S("png")},
	{.ext=S("jpg")},
	{.ext=S("jpeg")},
	{.ext=S("gif")},
	{.ext=S("svg"), .vector=true},
};
void init_1 (Plugin_api* plugin_api, Plugin_info* out__info) {
	api = *plugin_api;
	*out__info = (Plugin_info){
		.priority = -9999,
		.supported_formats_count = countof(supported_formats),
		.supported_formats = supported_formats,
	};
}

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
static inline void mem_copy (void* target, u64 bytecount, void* source) {
	memcpy(target, source, bytecount);
}
static String printstring (const char* str, ...) {
	va_list args;
	va_start(args, str);

	String s = {0};
	s.length = vsnprintf(NULL, 0, str, args);
	s.data = api.arena_alloc(NULL, s.length+1);
	vsnprintf(s.data, s.length+1, str, args);

	va_end(args);
	return s;
}

// #define WIN32_LEAN_AND_MEAN 1
#include <windows.h>
/*static Errnum os_read_entire_file (String filepath, u64* out__len, void** out__data) {
	Errnum e = 0;
	HANDLE file = CreateFileA(filepath.data, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (file != INVALID_HANDLE_VALUE) {
		e = 1;
	}
	else {
		LARGE_INTEGER s;
		BOOL success = GetFileSizeEx(file, &s);
		if (!success) {
			e = 2;
		}
		else {
			void* data = api.arena_alloc(NULL, s.QuadPart);
			DWORD bytesread = 0;
			BOOL success = ReadFile(file, data, s.QuadPart, &bytesread, NULL);
			if (!success) {
				e = 3;
			}
			else {
				*out__len = s.QuadPart;
				*out__data = data;
			}
		}
		CloseHandle(file);
	}
	return e;
}*/
static String os_get_temp_path (void) {
	String s = {0};
	
	CHAR buf [MAX_PATH+1];
	DWORD len = GetTempPathA(MAX_PATH+1, buf);
	DWORD attribs = GetFileAttributesA(buf);
	if (attribs != INVALID_FILE_ATTRIBUTES) {
		for (int i=0; i<len; i++) {
			if (buf[i] == '\\') buf[i] = '/';
		}
		while (len && buf[len-1] == '/') {
			len --;
			buf[len] = 0;
		}
		
		s.length = len;
		s.data = api.arena_alloc(NULL, len+1);
		mem_copy(s.data, len+1, buf);
	}
	
	return s;
}
static String read_file (String filepath) {
	String buffer = {0};
	HANDLE file = CreateFileA(filepath.data, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (file != INVALID_HANDLE_VALUE) {
		LARGE_INTEGER s;
		BOOL success = GetFileSizeEx(file, &s);
		if (success) {
			void* data = api.arena_alloc(NULL, s.QuadPart);
			DWORD bytesread = 0;
			BOOL success = ReadFile(file, data, s.QuadPart, &bytesread, NULL);
			if (success) {
				buffer.data = data;
				buffer.length = s.QuadPart;
			}
		}
		CloseHandle(file);
	}
	return buffer;
}
static Errnum write_file (String filepath, u64 datalength, void* data) {
	Errnum e = 0;
	HANDLE file = CreateFileA(filepath.data, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (file == INVALID_HANDLE_VALUE) {
		e = 1;
	}
	else {
		DWORD byteswritten = 0;
		BOOL success = WriteFile(file, data, datalength, &byteswritten, NULL);
		if (!success) {
			e = 2;
		}
		CloseHandle(file);
	}
	
	return e;
}
static Errnum delete_file (String filepath) {
	BOOL success = DeleteFileA(filepath.data);
	return (!success && GetLastError() != ERROR_FILE_NOT_FOUND) ? 1 : 0;
}
static Errnum os_execute_command (String cmd) {
	// https://learn.microsoft.com/en-us/windows/win32/api/processthreadsapi/ns-processthreadsapi-startupinfoa
	// https://learn.microsoft.com/en-us/windows/win32/api/processthreadsapi/nf-processthreadsapi-createprocessa
	STARTUPINFOA startupinfo = {
		.cb = sizeof(STARTUPINFOA),
		// .lpReserved = NULL,
		// .lpDesktop,
		// .lpTitle = NULL, // window title
		// DWORD  dwX;
		// DWORD  dwY;
		// DWORD  dwXSize;
		// DWORD  dwYSize;
		// DWORD  dwXCountChars,
		// DWORD  dwYCountChars,
		// DWORD  dwFillAttribute,
		// .dwFlags = 0,
		// WORD   wShowWindow,
		// WORD   cbReserved2,
		// LPBYTE lpReserved2,
		// HANDLE hStdInput,
		// HANDLE hStdOutput,
		// HANDLE hStdError
	};
	PROCESS_INFORMATION processinfo = {0};
		// HANDLE hProcess; // process handle
		// HANDLE hThread; // process thread
		// DWORD  dwProcessId;
		// DWORD  dwThreadId;
	if (true) {
		HANDLE childprocess_STDIN_read = NULL;
		HANDLE childprocess_STDIN_write = NULL;
		HANDLE childprocess_STDOUT_read = NULL;
		HANDLE childprocess_STDOUT_write = NULL;
		
		// Set the bInheritHandle flag so pipe handles are inherited.
		SECURITY_ATTRIBUTES secattribs = {
			.nLength = sizeof(SECURITY_ATTRIBUTES),
			.bInheritHandle = true,
			.lpSecurityDescriptor = NULL,
		};
		
		// Create a pipe for the child process's STDOUT.
		if ( !CreatePipe(&childprocess_STDOUT_read, &childprocess_STDOUT_write, &secattribs, 0) ) {
			printf("Failed CreatePipe\n");
			return 13371;
		}
		// Ensure the read handle to the pipe for STDOUT is not inherited.
		if ( !SetHandleInformation(childprocess_STDOUT_read, HANDLE_FLAG_INHERIT, 0) ) {
			printf("Failed SetHandleInformation\n");
			return 13372;
		}
		// Create a pipe for the child process's STDIN.
		if ( !CreatePipe(&childprocess_STDIN_read, &childprocess_STDIN_write, &secattribs, 0) ) {
			printf("Failed CreatePipe\n");
			return 13373;
		}
		// Ensure the write handle to the pipe for STDIN is not inherited.
		if ( !SetHandleInformation(childprocess_STDIN_write, HANDLE_FLAG_INHERIT, 0) ) {
			printf("Failed SetHandleInformation\n");
			return 13374;
		}
		
		startupinfo.hStdError = childprocess_STDOUT_write,
		startupinfo.hStdOutput = childprocess_STDOUT_write,
		startupinfo.hStdInput = childprocess_STDIN_read,
		startupinfo.dwFlags = STARTF_USESTDHANDLES;
		
		PROCESS_INFORMATION processinfo = {0};
		
		BOOL success = CreateProcessA(
			NULL,			// LPCTSTR lpApplicationName
			cmd.data,			// LPTSTR lpCommandLine
			NULL,			// process security attributes
			NULL,			// primary thread security attributes
			true,			// handles are inherited
			NORMAL_PRIORITY_CLASS|CREATE_NO_WINDOW,	// creation flags
			NULL,			// use parent's environment
			NULL,			// use parent's current directory
			&startupinfo,	// STARTUPINFO pointer
			&processinfo	// receives PROCESS_INFORMATION
		);
		if (!success) {
			int e = GetLastError();
			printf("Error starting process (with callback path)!, %i (", e);
			// switch (e) {
			// 	case ERROR_INVALID_NAME:   printf("ERROR_INVALID_NAME");   break;
			// 	case ERROR_FILE_NOT_FOUND: printf("ERROR_FILE_NOT_FOUND"); break;
			// }
			printf(")\n");
			printf("* command: (%.*s)\n", cmd.length,cmd.data);
			return 13375;
		}
		
		// Close handles to the stdin and stdout pipes no longer needed by the child process. If they are not explicitly closed, there is no way to recognize that the child process has ended.
		CloseHandle(childprocess_STDOUT_write);
		CloseHandle(childprocess_STDIN_read);
		
		const int BUFSIZE = 4096;
		DWORD bytesRead = 0;
		// DWORD bytesWritten = 0;
		// HANDLE hParentStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
		char buffer [BUFSIZE+1];
		
		while (1) {
			BOOL success = ReadFile(childprocess_STDOUT_read, buffer, BUFSIZE, &bytesRead, NULL);
			if ( !success || bytesRead == 0 ) break;
			String out = {.length=bytesRead, .data=buffer};
			// success = WriteFile(hParentStdOut, buffer, bytesRead, &bytesWritten, NULL);
			// if (! success ) break;
		}
		DWORD retcode = 0;
		success = GetExitCodeProcess(processinfo.hProcess, &retcode);
		// Close handles to the child process and its primary thread. Some applications might keep these handles to monitor the status of the child process, for example. NOTE: I don't know if these should be closed and/or where. Originally these were closed along with childprocessSTD*, but can't get return code if you do it there.
		CloseHandle(processinfo.hProcess);
		CloseHandle(processinfo.hThread);
		if (!success) {
			int e = GetLastError();
			printf("Error getting process return code!, %i\n", e);
			printf("%i\n", __LINE__);
			return 13376;
		}
		if (retcode) {
			printf("Returned error code!, %i\n", retcode);
		}
		return retcode;
	}
	else {
		BOOL success = CreateProcessA(
			NULL, // LPCTSTR lpApplicationName
			cmd.data, // LPTSTR lpCommandLine
			NULL, // LPSECURITY_ATTRIBUTES lpProcessAttributes,
			NULL, // LPSECURITY_ATTRIBUTES lpThreadAttributes,
			false, // BOOL bInheritHandles,
			NORMAL_PRIORITY_CLASS|CREATE_NO_WINDOW, // DWORD dwCreationFlags,
			NULL, // LPVOID lpEnvironment,
			NULL, // LPCSTR lpCurrentDirectory, // basically where the process is cd'd to
			&startupinfo, // LPSTARTUPINFOA lpStartupInfo,
			&processinfo // LPPROCESS_INFORMATION lpProcessInformation
		);
		if (!success) {
			int e = GetLastError();
			printf("Error starting process!!, %i (", e);
			// switch (e) {
			// 	case ERROR_INVALID_NAME:   printf("ERROR_INVALID_NAME");   break;
			// 	case ERROR_FILE_NOT_FOUND: printf("ERROR_FILE_NOT_FOUND"); break;
			// }
			printf(")\n");
			printf("* command: (%.*s)\n", cmd.length,cmd.data);
			return 13377;
		}
		DWORD retcode = 0;
		success = GetExitCodeProcess(processinfo.hProcess, &retcode);
		if (!success) {
			int e = GetLastError();
			printf("Error getting process return code!, %i\n", e);
			return 13378;
		}
		if (retcode) {
			printf("Returned error code!, %i\n", retcode);
		}
		return retcode;
	}
}

#define STB_IMAGE_IMPLEMENTATION
#define STB_IMAGE_STATIC
#define STBI_NO_STDIO
#define STBI_NO_FAILURE_STRINGS
// #define STBI_FAILURE_USERMSG
#define STBI_ONLY_BMP
#define STBI_MALLOC(sz) api.arena_alloc(NULL,sz)
#define STBI_REALLOC(p,newsz) api.arena_alloc(p,newsz)
#define STBI_FREE(p) do{}while(0)
#include "stb_image.h"

Errnum load_image (String ext, u64 len, void* data, f64 zoom, Plugin_file* out__file) {
	String tpath = os_get_temp_path();
	if (!tpath.data) return 12345678;
	String temppath1 = printstring("%.*s/kaniview_magick_temp.%.*s", tpath.length, tpath.data, ext.length, ext.data);
	String temppath2 = printstring("%.*s/kaniview_magick_temp.bmp", tpath.length, tpath.data);
	Errnum e = write_file(temppath1, len, data);
	if (e) return 100+e;
	String cmd;
	if (zoom == 1.0) cmd = printstring("magick -quality 00 -background none \"%s\" \"%s\"", temppath1.data, temppath2.data);
	else             cmd = printstring("magick -quality 00 -background none -density %i \"%s\" \"%s\"", (int)(96.0*zoom+0.5), temppath1.data, temppath2.data);
	e = os_execute_command(cmd);
	delete_file(temppath1);
	if (e) return 1;
	String file = read_file(temppath2);
	if (!file.data) return 2;
	delete_file(temppath2);
	
	len = file.length;
	data = file.data;
	if (len > I32_MAX) return 3; // stb_image limitation, all the variables are ints.
	
	int channels = 0;
	int w = 0;
	int h = 0;
	Rgba8* stb_frame = (Rgba8*)stbi_load_from_memory(data, len, &w, &h, &channels, 4);
	if (!stb_frame) return 10;
	if (w <= 0 || h <= 0) return 11;
	
	out__file->frames = api.arena_alloc(NULL, sizeof(Plugin_frame));
	if (!out__file->frames) return 12;
	out__file->frame_count = 1;
	out__file->w = w;
	out__file->h = h;
	Plugin_frame frame = {
		.pixels = api.permanent_alloc(NULL, (u64)w*(u64)h*sizeof(Rgba8)),
	};
	for (u64 i=0; i<(u64)w*(u64)h; i++) {
		frame.pixels[i] = stb_frame[i];
	}
	*out__file->frames = frame;
	
	// stbi_image_free(stbdata); // Allocated with api.arena_alloc so this doesn't actually need to be freed.
	return 0;
}
