
// Types.

	// ints
	typedef signed char        i8;
	typedef signed short       i16;
	typedef signed int         i32;
	typedef signed long long   i64;
	typedef unsigned char      u8;
	typedef unsigned short     u16;
	typedef unsigned int       u32;
	typedef unsigned long long u64;
	// floats
	typedef float              f32;
	typedef double             f64;
	// bool
	typedef _Bool              bool;
	// error
	typedef signed int         Errnum;
	// constants
	#ifndef true
		#define true ((_Bool)1)
	#endif
	#ifndef false
		#define false ((_Bool)0)
	#endif
	#ifndef NULL
		#define NULL ((void*)0)
	#endif
	#define U8_MAX  ((u8)0xFF) //  255
	#define I8_MAX  ((i8)0x7F) //  127
	#define I8_MIN  ((i8)0x80) // -128
	#define U16_MAX ((u16)0xFFFF) //  65535
	#define I16_MAX ((i16)0x7FFF) //  32767
	#define I16_MIN ((i16)0x8000) // -32768
	#define U32_MAX ((u32)0xFFFFFFFF) //  4294967295
	#define I32_MAX ((i32)0x7FFFFFFF) //  2147483647
	#define I32_MIN ((i32)0x80000000) // -2147483648
	#define U64_MAX ((u64)0xFFFFFFFFFFFFFFFF) // 18446744073709551615
	#define I64_MAX ((i64)0x7FFFFFFFFFFFFFFF) //  9223372036854775807
	#define I64_MIN ((i64)0x8000000000000000) // -9223372036854775808
	// special types
	typedef struct String String;
	typedef struct Rgba8 Rgba8;
	struct String {
		i64 length;
		char* data;
	};
	struct Rgba8 {
		u8 r;
		u8 g;
		u8 b;
		u8 a;
	};
	// Use this to convert a C string into String. Instead of "hello", do S("hello")
	#define S(s) ((String){sizeof("" s "")-1,s})
	// Self-explanatory.
	#define strings_are_equal(a, b) ((a).length==(b).length && !memcmp((a).data, (b).data, (b).length))
	// Use this to get the number of items in an array.
	#define countof(a) (sizeof(a)/sizeof(*(a)))

// API.

	typedef struct Plugin_file_format Plugin_file_format;
	typedef struct Plugin_info Plugin_info;
	typedef struct Plugin_api Plugin_api;
	typedef struct Plugin_frame Plugin_frame;
	typedef struct Plugin_file Plugin_file;
	
	struct Plugin_file_format {
		union {
			u64 flags;
			struct {
				bool vector : 1; // If this a vector format, set this to true. Instead of calling load_image, load_scaled_vector_image will be called every time the canvas zoom level changes.
			};
		};
		String ext; // Extension of the file, for example "jpg". Must be all lower case.
	};
	struct Plugin_info {
		i64 priority; // If there's multiple plugins that support the same format, the one with higher priority is used. If a plugin returns an error, the next priority one is used.
		u64 supported_formats_count; // Number of items on the pointer below.
		Plugin_file_format* supported_formats; // List of file extensions, for example "jpg","png". Must be all lower case.
	};
	struct Plugin_api { // Note: all allocated memory is zeroed. Even if you set the arena position, subsequent allocations will be zeroed.
		void* (*permanent_alloc) (void* mem, u64 amount); // Allocate the pixel data for each frame with this (w*h*sizeof(Rgba8)). Use arena_alloc() for temporary allocations unless they're super huge.
		void  (*permanent_free)  (void* mem);
		void* (*arena_alloc)     (void* mem, u64 amount); // Use this to allocate any arbitrary (temporary) memory. Does not need to be freed. Set mem to a previous allocation to re-allocate it, it can be NULL.
		u64   (*arena_get_pos)   (void); // alloc() is an arena allocator that keeps increasing until some very very high maximum cap. To prevent wasting memory needlessly, you can get the current size of the arena, and later restore it, deleting all the data that was allocated since the get. The file data is also here, setting the arena to 0 will cause the file data to be overwritten.
		void  (*arena_set_pos)   (u64 pos); // Do not send arbitrary numbers to this, only values that you get from arena_get_size().
	};
	struct Plugin_frame {
		u64 flags; // Not used for now.
		u64 duration;
		Rgba8* pixels; // Allocate this with api.alloc_pixels(file.w, file.h), every frame should be a keyframe, it's up to the decoder to turn relative frames into keyframes.
	};
	struct Plugin_file {
		u64 w;
		u64 h;
		u64 anim_play_count; // How many times to repeat the animation. 0 = infinite. This is ignored since playback is controlled by the UI.
		u64 frame_count; // Static images should only have 1.
		Plugin_frame* frames; // Allocate this with api.alloc()
	};
