
#include "plugin_base.h"
Plugin_api api = {0};
Plugin_file_format supported_formats [] = {
	{.ext=S("gif")},
};
void init_1 (Plugin_api* plugin_api, Plugin_info* out__info) {
	api = *plugin_api;
	*out__info = (Plugin_info){
		.priority = 0,
		.supported_formats_count = countof(supported_formats),
		.supported_formats = supported_formats,
	};
}

// #include <stdio.h>

#define READ(T, name) T name = *(T*)(data+i); i += sizeof(T);
#define READ_AS(T, name, Tas) Tas name = *(T*)(data+i); i += sizeof(T);
#define REMAIN (len-i)

static void decode_lzw (u8* data, int min_code_size, u8* out, int out_len) {
	// I got this function from chatgpt because I have no interest learning this shit, I sure hope there's no problems in it...
	typedef struct { u16 prefix; u8 suffix; } Entry;
	#define MAX_DICT 4096
	
	Entry dict [MAX_DICT] = {0};
	u8 stack [MAX_DICT] = {0};
	int bitpos = 0;

	int clear = 1 << min_code_size;
	int end = clear + 1;
	int code_size = min_code_size + 1;
	int next_code = end + 1;

	for (int i=0; i<clear; i++) {
		dict[i].prefix = 0xFFFF;
		dict[i].suffix = i;
	}

	int old = -1;
	int out_pos = 0;

	while (out_pos < out_len) {
		int code = 0;
		for (int i=0; i<code_size; i++) {
			int byte = data[bitpos >> 3];
			int bit  = (byte >> (bitpos & 7)) & 1;
			code |= bit << i;
			bitpos ++;
		}
		if (code == clear) {
			code_size = min_code_size + 1;
			next_code = end + 1;
			old = -1;
			continue;
		}
		if (code == end) {
			break;
		}
		
		int cur = code;
		int sp = 0;
		
		if (cur >= next_code) {
			stack[sp++] = dict[old].suffix;
			cur = old;
		}
		while (cur >= clear) {
			stack[sp++] = dict[cur].suffix;
			cur = dict[cur].prefix;
		}
		
		u8 first = cur;
		stack[sp++] = first;
		
		while (sp && out_pos < out_len) {
			out[out_pos++] = stack[--sp];
		}
		
		if (old != -1 && next_code < MAX_DICT) {
			dict[next_code].prefix = old;
			dict[next_code].suffix = first;
			next_code ++;
			
			if (next_code == (1 << code_size) && code_size < 12) {
				code_size ++;
			}
		}
		
		old = code;
	}
}
Errnum load_image (String ext, u64 len, void* data, f64 zoom, Plugin_file* out__file) {
	// https://www.w3.org/Graphics/GIF/spec-gif89a.txt
	// TODO: the buffer overflow checks are kind of half assed, there's probably a smarter way to do stuff.
	if (len < 4+2 + 2*2+3 + 1) return 1;
	u64 i = 0;
	
	// Header (6 bytes), "GIF87a" or "GIF89a". Technically the last 3 letters are the version, but only 2 versions exist and both have the same first character, so whatever.
	READ(u32, header1)
	READ(u16, header2)
	if (header1 != *(u32*)"GIF8") return 2;
	if (header2 != *(u16*)"7a" && header2 != *(u16*)"9a") return 3;
	
	// Logical Screen Descriptor (7 bytes).
	READ_AS(u16, image_w, u32)
	READ_AS(u16, image_h, u32)
	READ(u8, global_color_info)
		// 10000000  Global Color Table Flag = is color table here?
		// 01110000  Color Resolution = "bits per primary color in the original image, represents the size of the entire palette from which the colors in the graphic were selected, not the number of colors actually used in the graphic" Ignore?
		// 00001000  Sort Flag = colors are sorted by importance, so decoders without full color capability can use only part of the table. Ignore this.
		// 00000111  Size of Global Color Table = number of colors, use a power function (see below) to turn this into the true length.
	READ(u8, bg_color_index) // When you encounter this color index, it should be treated as an empty (transparent) pixel. Use only if there's a global color table.
	READ(u8, pixel_aspect_ratio) // aspect_ratio = (pixel_aspect_ratio + 15) / 64
	
	// Global Color Table. A list of RGB values.
	typedef struct { u8 r; u8 g; u8 b; } Gif_Rgb8;
	u16 global_color_table_size = 0;
	Gif_Rgb8* global_color_table = NULL;
	if (global_color_info & 0b10000000) {
		global_color_table = data+i;
		global_color_table_size = global_color_info & 0b00000111;
		global_color_table_size = 1 << (global_color_table_size+1); // powl(2, global_color_table_size+1);
		if (REMAIN < global_color_table_size*sizeof(Gif_Rgb8)+1) return 4;
		i += global_color_table_size * sizeof(Gif_Rgb8);
	}
	
	Gif_Rgb8* active_color_table = global_color_table;
	u16 active_color_table_size = global_color_table_size;
	
	Rgba8* canvas = api.arena_alloc(NULL, image_w*image_h*sizeof(Rgba8)); // Render the animation frames here.
	u32 frames_allocated = 0;
	
	void free_allocated_frames (void) {
		// Failed, free all the frame pixels.
		for (u64 f=0; f<out__file->frame_count; f++) {
			api.permanent_free(out__file->frames[f].pixels);
		}
	}
	
	// Blocks.
	bool gce_seen = false;
	u64 gce_duration = 0;
	bool gce_transparency = false;
	u8 gce_transparent_color_index = 0;
	u8 gce_disposal_method = 0;
	while (i < len) {
		READ(u8, block_id)
		if (block_id == 0x3B) { // Trailer. ';'
			break;
		}
		else if (block_id == 0x21) { // Extension block. '!'
			if (REMAIN < 2) return 4;
			READ(u8, extension_id)
			if (extension_id == 0xFE) { // Comment.
				while (1) {
					READ(u8, data_block_size)
					if (data_block_size == 0) break;
					if (REMAIN < data_block_size+1) return 4;
					i += data_block_size;
				}
			}
			else if (extension_id == 0x01) { // Plain Text.
				READ(u8, block_size)
				if (REMAIN < block_size) return 4;
				i += block_size;
				while (1) {
					READ(u8, data_block_size)
					if (data_block_size == 0) break;
					if (REMAIN < data_block_size+1) return 4;
					i += data_block_size;
				}
			}
			else if (extension_id == 0xFF) { // Application-defined Extension.
				READ(u8, block_size)
				if (REMAIN < block_size) return 4;
				i += block_size;
				while (1) {
					READ(u8, data_block_size)
					if (data_block_size == 0) break;
					if (REMAIN < data_block_size+1) return 4;
					i += data_block_size;
				}
			}
			else if (extension_id == 0xF9) { // Graphic Control Extension.
				// Note about disposal: the descriptions below are a bit confusing, they define what should happen after this frame, for example restoring the previous frame. The way this plugin implements it is that the "canvas" and "frame" are separate images, and you operate on them differently depending on disposal method. 0/1 = draw pixels to canvas, copy canvas to frame. 2 = copy canvas to frame, draw pixels to frame and clear the canvas inside the frame region. 3 = copy canvas to frame, draw pixels to frame.
				READ(u8, block_size)
				if (REMAIN < block_size+1) return 4;
				READ(u8, control_info)
					// 00011100 = Disposal Method
						// 0    No disposal specified. The decoder is not required to take any action. This is usually treated the same way as 1.
						// 1    Do not dispose. The graphic is to be left in place.
						// 2    Restore to background color. The area used by the graphic must be restored to the background color.
						// 3    Restore to previous. The decoder is required to restore the area overwritten by the graphic with what was there prior to rendering the graphic.
					// 00000010 = User Input Flag, ignore this crap, if true then player should wait for user input before continuing.
					// 00000001 = Transparency Flag, if true then "transparent_color_index is present". TODO: what if this is false? Should transparent pixels just use the color value?
				READ_AS(u16, delay_time, u64) // If not 0, you need delay_time*(1/100) seconds of delay (i.e. multiply it by 10 to get milliseconds).
				READ(u8, transparent_color_index) // "present only if Transparency Flag is 1". If you encounter this color, don't do anything. TODO: is transparent color behavior affected by Disposal Method?
				READ(u8, terminator)
				
				if (block_size != 4) { free_allocated_frames(); return 21; }
				if (terminator != 0) { free_allocated_frames(); return 22; }
				if (!delay_time) delay_time = 10; // There doesn't seem to be a mandate for how to handle 0 delay in normal (non- User Input Flagged) animations. Web browsers appear to treat 0 delay as 10. It's probably best to go with that instead of 1 since most of your gifs probably come from the web, and you'd expect them to play back the same way.
				
				// if (gce_seen) return 1; // Technically this isn't valid, but it doesn't really matter if there's multiple. Maybe it's better to just accept this file.
				gce_seen = true;
				gce_transparency = control_info&0b00000001;
				gce_duration = delay_time*10llu*1000llu;
				gce_transparent_color_index = transparent_color_index;
				gce_disposal_method = (control_info&0b00011100) >> 2;
				if (gce_disposal_method == 1) gce_disposal_method = 0; // These are the same so easier to just merge them.
				if (gce_disposal_method > 3) gce_disposal_method = 0; // In theory there may be gifs that use invalid method, I'm not sure what should be done about them.
			}
			else {
				return 20;
			}
		}
		else if (block_id == 0x2C) { // Image Descriptor (9+1 bytes). ','
			if (REMAIN < 2*4+1 + 1 + 1) return 4;
			READ_AS(u16, frame_x, u32)
			READ_AS(u16, frame_y, u32)
			READ_AS(u16, frame_w, u32)
			READ_AS(u16, frame_h, u32)
			READ(u8, color_info)
				// 10000000  Local Color Table Flag = if true, a local color table for this frame comes next.
				// 01000000  Interlace Flag = The rows of pixels in the image are arranged in an interlaced pattern, e.g. you skip lines and then start over several times. I think the purpose of this was to help the image display faster on ancient super old computers, similar to how JPG images can load progressively (shows up blurry and then sharpens as more of the image loads).
					// Group 1 : Every 8th row, starting with row 0.
					// Group 2 : Every 8th row, starting with row 4.
					// Group 3 : Every 4th row, starting with row 2.
					// Group 4 : Every 2nd row, starting with row 1.
				// 00100000  Sort Flag = Ignore this.
				// 00011000  Reserved
				// 00000111  Size of Local Color Table = number of colors, use the power function.
			if (frame_x+frame_w > image_w) { free_allocated_frames(); return 11; }
			if (frame_y+frame_h > image_h) { free_allocated_frames(); return 12; }
			
			// Local Color Table. Local table is only used for this image, images that don't have one should use the global table. According to spec it's valid for an image to have neither color table, in that case the table from previous image should be used. I'm not sure if those kinds of images exist in practice and what should be done with them by modern decoders, maybe some kind of default fallback palette should be used.
			u16 local_color_table_size = 0;
			Gif_Rgb8* local_color_table = NULL;
			if (color_info & 0b10000000) {
				local_color_table = data+i;
				local_color_table_size = color_info & 0b00000111;
				local_color_table_size = 1 << (local_color_table_size+1); // powl(2, local_color_table_size+1);
				if (REMAIN < local_color_table_size*sizeof(Gif_Rgb8)+1) return 4;
				i += local_color_table_size * sizeof(Gif_Rgb8);
			}
			// printf("FRAME %i = %i %i %i %i, disposal %i, transparent %i, local table %i, interlace %i\n", out__file->frame_count, frame_x, frame_y, frame_w, frame_h, gce_disposal_method, gce_transparency, local_color_table?1:0, (color_info&0b01000000)?1:0);
			
			// Table Based Image Data.
			READ(u8, lzw_minimum_code_size)
			// Concatenate data blocks. This concatenates in-place, screwing up the original file data along the way, but that's fine since it won't be needed again.
			u8* lzw_data = data+i;
			u32 lzw_length = 0;
			while (1) {
				READ(u8, data_block_size)
				if (data_block_size == 0) break;
				if (REMAIN < data_block_size+1) return 4;
				while (data_block_size) {
					lzw_data[lzw_length] = *(u8*)(data+i);
					lzw_length ++;
					i ++;
					data_block_size --;
				}
			}
			
			// Decode.
			u64 arena_pos = api.arena_get_pos();
			u8* color_indices = api.arena_alloc(NULL, frame_w*frame_h);
			decode_lzw(lzw_data, lzw_minimum_code_size, color_indices, frame_w*frame_h);
			
			// Select color table. In theory there might be an image that swaps between local color tables and has some gaps in-between, this way a previous local table is used. TODO: Not sure if that's acceptable...
			if (local_color_table) {
				active_color_table = local_color_table;
				active_color_table_size = local_color_table_size;
			}
			else if (global_color_table) {
				active_color_table = global_color_table;
				active_color_table_size = global_color_table_size;
			}
			if (!active_color_table) { free_allocated_frames(); return 13; }
			
			// Interlacing = uncommon mode where rows are staggered in an annoying way.
			// Group 1: every 8th row starting from 0 -> 0, 8, 16...
			// Group 2: every 8th row starting from 4 -> 4, 12, 20...
			// Group 3: every 4th row starting from 2 -> 2, 6, 10, 14, 18...
			// Group 4: every 2nd row starting from 1 -> 1, 3, 5, 7, 9, 11, 13, 15, 17, 19...
			bool interlacing = (color_info&0b01000000) ? true : false;
			u32 ilgroup1 = (frame_h + 7) / 8;
			u32 ilgroup2 = (frame_h + 3) / 8 + ilgroup1;
			u32 ilgroup3 = (frame_h + 1) / 4 + ilgroup2;
			
			// Render.
			// Disposal 0 and 1 are the same, they draw to canvas and use that result.
			// Disposal 2 and 3 are very similar, they draw to the current frame instead of canvas. The difference is that 2 will clear the canvas with background/transparency inside the frame region. 3 doesn't need to do anything else because keeping frame and canvas separated automatically accomplishes what it's meant to do.
			Plugin_frame frame = {
				.duration = gce_duration,
				.pixels = api.permanent_alloc(NULL, (u64)image_w*(u64)image_h*sizeof(Rgba8)),
			};
			if (gce_disposal_method == 2 || gce_disposal_method == 3) {
				for (u32 x=0; x<image_w*image_h; x++) {
					frame.pixels[x] = canvas[x];
				}
			}
			u32 index = 0;
			u32 interlacey = 0;
			for (u32 y=frame_y; y<frame_y+frame_h; y++) {
				u32 dest = y*image_w;
				if (interlacing) {
					if      (interlacey < ilgroup1) dest = (frame_y+interlacey*8)*image_w;
					else if (interlacey < ilgroup2) dest = (frame_y+(interlacey-ilgroup1)*8+4)*image_w;
					else if (interlacey < ilgroup3) dest = (frame_y+(interlacey-ilgroup2)*4+2)*image_w;
					else                            dest = (frame_y+(interlacey-ilgroup3)*2+1)*image_w;
					interlacey ++;
				}
				dest += frame_x;
				for (u32 x=frame_x; x<frame_x+frame_w; x++, index++, dest++) {
					u8 color_index = color_indices[index];
					if (gce_disposal_method == 2) { // The ENTIRE region needs to be restored, not just the written pixels. Only 2 needs to do this, 3 restores the region to previous frame, which is already on the canvas.
						if (gce_transparency || !global_color_table) {
							canvas[dest] = (Rgba8){0};
						}
						else {
							Gif_Rgb8 bg = global_color_table[bg_color_index];
							canvas[dest] = (Rgba8){.r=bg.r, .g=bg.g, .b=bg.b, .a=255};
						}
					}
					
					if (gce_transparency && color_index == gce_transparent_color_index) continue;
					
					Gif_Rgb8 color = active_color_table[color_index];
					if (gce_disposal_method == 0) {
						canvas[dest] = (Rgba8){.r=color.r, .g=color.g, .b=color.b, .a=255};
					}
					else /*if (gce_disposal_method == 2 || gce_disposal_method == 3)*/ {
						frame.pixels[dest] = (Rgba8){.r=color.r, .g=color.g, .b=color.b, .a=255};
					}
				}
			}
			if (gce_disposal_method == 0) {
				for (u32 x=0; x<image_w*image_h; x++) {
					frame.pixels[x] = canvas[x];
				}
			}
			api.arena_set_pos(arena_pos);
			
			// Note: can't check for gce_handled since gce is supposedly optional. I have no idea how the gif is supposed to be rendered without it though, I don't see clarification in the documentation, Grok says that it should be rendered immediately but some players may put in a 10-100ms delay. In theory you could use multiple frames to create a gif image with more colors than can fit in the color table, by having multiple instant frames with their own color tables, but I don't know if that's valid.
			if (!frames_allocated) {
				frames_allocated = 64;
				out__file->frames = api.arena_alloc(NULL, sizeof(Plugin_frame)*frames_allocated);
			}
			else if (out__file->frame_count == frames_allocated) {
				frames_allocated *= 2;
				out__file->frames = api.arena_alloc(out__file->frames, sizeof(Plugin_frame)*frames_allocated);
			}
			out__file->frames[out__file->frame_count] = frame;
			out__file->frame_count ++;
			gce_seen = false;
			gce_duration = 0;
			gce_transparent_color_index = 0;
			gce_disposal_method = 0;
		}
		else {
			free_allocated_frames();
			return 4;
		}
	}
	
	out__file->w = image_w;
	out__file->h = image_h;
	
	return 0;
}
