
// Create.

	typedef struct {
		union {
			struct {
				i64 length; // How many characters the array contains (not including null terminator).
				char* data;
			};
			String string;
		};
		i64 maxlength; // How many characters there's memory for.
	} Mfstr;
	
	static Mfstr mfstr_new_exact_length (i64 length) {
		// Note: This does NOT allocate space for null terminator.
		ASSERT(length > 0);
		
		Mfstr this = {
			.maxlength = length,
			.data = os_mem_alloc(length+1),
		};
		if (!this.data) {
			#if !BUILD_RELEASE
				lprintf_error("Ohhhh shit failed to allocate array!\n");
			#endif
			return (Mfstr){0};
		}
		this.data[0] = 0;
		
		return this;
	}
	static Mfstr mfstr_new_with_size (i64 min_length) {
		i64 length = 8;
		while (length < min_length) length *= 2;
		Mfstr this = mfstr_new_exact_length(length);
		
		return this;
	}
	static Mfstr mfstr_new_from_data (i64 amount, void* data) {
		ASSERT(amount > 0);
		ASSERT(data);
		
		Mfstr this = mfstr_new_with_size(amount);
		if (this.data) {
			mem_copy(this.data, amount, data);
			this.length = amount;
			this.data[amount] = 0;
		}
		
		return this;
	}
	static Mfstr mfstr_new_from_string (String str) {
		return mfstr_new_from_data(str.length, str.data);
	}
	static Mfstr mfstr_new_from_cstr (char* str) {
		return mfstr_new_from_data(strlen(str), str);
	}
	#define mfstr_new(...) \
		_Generic( \
			ARG_1(__VA_ARGS__), \
			String: mfstr_new_from_string, \
			char*: mfstr_new_from_cstr, \
			default: mfstr_new_with_size \
		)(__VA_ARGS__)
	
	static void mfstr_free (Mfstr* this) {
		if (this->data) os_mem_free(this->data);
		*this = (Mfstr){0};
	}
	static void mfstr_expand_to (Mfstr* this, i64 amount) {
		ASSERT(this);
		ASSERT(this->data);
		
		if (this->maxlength >= amount) return;
		
		#if !BUILD_RELEASE
			lprintf_dev("Mfstr reallocated %i -> %i. ", this->maxlength, amount);
		#endif
		
		while (this->maxlength < amount) {
			this->maxlength *= 2;
		}
		this->data = os_mem_realloc(this->data, this->maxlength+1);
	}
	#define MFSTR_EXPAND_IF_NECESSARY(this, amount, ...) 

// Append.

	static char* mfstr_append_data (Mfstr* this, i64 amount, void* new_data) {
		ASSERT(this);
		ASSERT(this->data);
		
		if (amount <= 0) return NULL;
		MFSTR_EXPAND_IF_NECESSARY(this, amount, NULL)
		if (this->maxlength < this->length+(amount)) {
			mfstr_expand_to(this, this->length+(amount));
			if (!this->data) return NULL;
		}
		
		char* r = this->data+this->length;
		
		if (new_data) mem_copy(this->data+this->length, amount, new_data);
		this->length += amount;
		this->data[this->length] = 0;
		
		return r;
	}
	static char* mfstr_append_cstr (Mfstr* this, char* str) {
		return mfstr_append_data(this, strlen(str), str);
	}
	static char* mfstr_append_string (Mfstr* this, String str) {
		return mfstr_append_data(this, str.length, str.data);
	}
	static char* mfstr_append_int (Mfstr* this, i64 integer) {
		INLINE_STRING_FROM_I64_FORCE(s, integer, 0, '0');
		return mfstr_append_data(this, s_length, s);
	}
	#define mfstr_append(...) \
		_Generic( \
			ARG_2(__VA_ARGS__), \
			String: mfstr_append_string, \
			char*: mfstr_append_cstr, \
			default: _Generic( \
				ARG_3(__VA_ARGS__), \
				NO_ARG: mfstr_append_int, \
				default: mfstr_append_data \
			) \
		)(__VA_ARGS__)
