/*
	- Cannot discover functions/structs/macros because #ifdefs may shuffle their definitions around or replace a function with an empty macro for release builds or whatever.
		- Can maybe inject stuff (function id, START/END/RETURN()) to functions since they are local to each function.
	
	- Features
		- Ability to just import files, no headers necessary. Use #section to organize code.
		- Character literals are converted to hex values, multiple characters supported. 'Ok!' -> 0x216B4F
		- Strings with length. S"Loller coaster" -> ((String){.length=14,.data="Loller coaster"})
	
	- TODO
		- optimize, especially skipping comments
		
		- replace character literals
		? string macros: "cstr" is required or else the string gets wrapped into ((String){.length=123,.data=""})


set preprocess="C:/Users/Sun/Desktop/Stuff/Make/Apps/lang_sbc/release/sbc.exe" "%~dp0release/main.c" "%~dp0release/_sbc_output.c"

#section DEFINES;
	#import "foo.c"
#section TYPEDEFS;
	typedef struct xxxx xxxx;
#section STRUCTS;
#section FUNCTIONDEFS;
#section GLOBALS;
#section FUNCTIONS;

*/

#include "base.c"

// kw

	typedef enum : u8 {
		KEYWORD_NONE,
		
		// KEYWORD_H_IF,
		// KEYWORD_H_ELIF,
		// KEYWORD_H_ELSE,
		// KEYWORD_H_ENDIF,
		// KEYWORD_H_DEFINED, // New
		// KEYWORD_H_INCLUDED, // New
		// KEYWORD_H_IMPORTED, // New
		// KEYWORD_H_EMBEDDED, // New
		
		KEYWORD_H_SECTION, // New
		// KEYWORD_H_GLOBAL, // New
		KEYWORD_H_IMPORT, // New
		// KEYWORD_H_INCLUDE,
		// KEYWORD_H_EMBED,
		// KEYWORD_H_DEFINE,
		// KEYWORD_H_UNDEF,
		// KEYWORD_H_START,
		// KEYWORD_H_END,
		
		// KEYWORD_STRUCT,
		// KEYWORD_UNION,
		// KEYWORD_ENUM,
		// KEYWORD_FUNCTION,
		// KEYWORD_TYPEDEF,
		
		// KEYWORD_GOTO,
		// KEYWORD_IF,
		// KEYWORD_ELSE,
		// KEYWORD_SWITCH,
		// KEYWORD_CASE,
		// KEYWORD_DEFAULT,
		// KEYWORD_DO,
		// KEYWORD_WHILE,
		// KEYWORD_FOR,
		// KEYWORD_CONTINUE,
		// KEYWORD_BREAK,
		// KEYWORD_RETURN,
		
		// KEYWORD_SIZEOF,
		// KEYWORD_TYPEOF,
		// KEYWORD_ALIGNAS,
		// KEYWORD_ALIGNOF,
		// KEYWORD_LINKED, // New
		// KEYWORD_INLINE,
		// KEYWORD_NOINLINE,
		// KEYWORD_NOINJECT, // New
		// KEYWORD_REGISTER,
		// KEYWORD_RESTRICT,
		// KEYWORD_AUTO,
		// KEYWORD_CONST,
		// KEYWORD_EXTERN,
		// KEYWORD_STATIC, // Obsolete
		// KEYWORD_THREAD_LOCAL,
		// KEYWORD_VOLATILE,
		
		// KEYWORD_H_ON_FUNCTION_ENTER,
		// KEYWORD_H_ON_FUNCTION_EXIT,
		// KEYWORD_H_ENABLE_FUNCTION_NAMES_LIST,
		
		// #ifdef,
		// #ifndef,
		// #elifdef,
		// #elifndef,
		// #pragma,
		// #line,
		// #error,
		// #warning,
		
		// defined,
		// __has_include,
		// __has_embed,
		// __has_c_attribute,
		
		// typeof_unqual,
		// nullptr,
		// constexpr,
		// static_assert,
		
		// _Atomic,
		// _Bitint,
		// _Complex,
		// _Generic,
		// _Imaginary,
		// _Alignas, // deprecated in C23
		// _Alignof, // deprecated in C23
		// _Bool, // deprecated in C23
		// _Noreturn, // deprecated in C23
		// _Static_assert, // deprecated in C23
		// _Thread_local, // deprecated in C23
	} KEYWORD;
	static KEYWORD string_to_keyword (String word) {
		if (word.length <= sizeof(u64)) {
			u64 x1 = 0;
			mem_copy(&x1, word.length, word.data);
			switch (x1) {
				// case 0x0000000000006F64: return KEYWORD_DO; // do
				// case 0x0000000000006669: return KEYWORD_IF; // if
				// case 0x0000000000666923: return KEYWORD_H_IF; // #if
				// case 0x0000000000726F66: return KEYWORD_FOR; // for
				// case 0x00000000646E6523: return KEYWORD_H_END; // #end
				// case 0x000000006F747561: return KEYWORD_AUTO; // auto
				// case 0x0000000065736163: return KEYWORD_CASE; // case
				// case 0x0000000065736C65: return KEYWORD_ELSE; // else
				// case 0x000000006D756E65: return KEYWORD_ENUM; // enum
				// case 0x000000006F746F67: return KEYWORD_GOTO; // goto
				// case 0x00000066696C6523: return KEYWORD_H_ELIF; // #elif
				// case 0x00000065736C6523: return KEYWORD_H_ELSE; // #else
				// case 0x0000006B61657262: return KEYWORD_BREAK; // break
				// case 0x00000074736E6F63: return KEYWORD_CONST; // const
				// case 0x0000006E6F696E75: return KEYWORD_UNION; // union
				// case 0x000000656C696877: return KEYWORD_WHILE; // while
				// case 0x00006465626D6523: return KEYWORD_H_EMBED; // #embed
				// case 0x00006669646E6523: return KEYWORD_H_ENDIF; // #endif
				// case 0x0000747261747323: return KEYWORD_H_START; // #start
				// case 0x00006665646E7523: return KEYWORD_H_UNDEF; // #undef
				// case 0x00006E7265747865: return KEYWORD_EXTERN; // extern
				// case 0x000064656B6E696C: return KEYWORD_LINKED; // linked
				// case 0x0000656E696C6E69: return KEYWORD_INLINE; // inline
				// case 0x00006E7275746572: return KEYWORD_RETURN; // return
				// case 0x0000666F657A6973: return KEYWORD_SIZEOF; // sizeof
				// case 0x0000636974617473: return KEYWORD_STATIC; // static
				// case 0x0000746375727473: return KEYWORD_STRUCT; // struct
				// case 0x0000686374697773: return KEYWORD_SWITCH; // switch
				// case 0x0000666F65707974: return KEYWORD_TYPEOF; // typeof
				// case 0x00656E6966656423: return KEYWORD_H_DEFINE; // #define
				// case 0x00666965736C6523: return KEYWORD_H_ELSEIF; // #elseif
				case 0x0074726F706D6923: return KEYWORD_H_IMPORT; // #import
				// case 0x0073616E67696C61: return KEYWORD_ALIGNAS; // alignas
				// case 0x00666F6E67696C61: return KEYWORD_ALIGNOF; // alignof
				// case 0x00746C7561666564: return KEYWORD_DEFAULT; // default
				// case 0x0066656465707974: return KEYWORD_TYPEDEF; // typedef
				// case 0x006C61626F6C6723: return KEYWORD_H_GLOBAL; // #global
				// case 0x656E696C6E696F6E: return KEYWORD_NOINLINE; // noinline
				// case 0x7463656A6E696F6E: return KEYWORD_NOINJECT; // noinject
				// case 0x64656E6966656423: return KEYWORD_H_DEFINED; // #defined
				// case 0x6564756C636E6923: return KEYWORD_H_INCLUDE; // #include
				case 0x6E6F697463657323: return KEYWORD_H_SECTION; // #section
				// case 0x65756E69746E6F63: return KEYWORD_CONTINUE; // continue
				// case 0x6E6F6974636E7566: return KEYWORD_FUNCTION; // function
				// case 0x7265747369676572: return KEYWORD_REGISTER; // register
				// case 0x7463697274736572: return KEYWORD_RESTRICT; // restrict
				// case 0x656C6974616C6F76: return KEYWORD_VOLATILE; // volatile
			}
		}
		else if (word.length <= sizeof(u64)*2) {
			// u64 x1 = *(u64*)word.data;
			// u64 x2 = 0;
			// mem_copy(&x2, word.length-sizeof(u64), word.data+sizeof(u64));
			// if (false) {}
			// else if (x1 == 0x65646465626D6523 && x2 == 0x0000000000000064) return KEYWORD_H_EMBEDDED; // #embedded
			// else if (x1 == 0x6574726F706D6923 && x2 == 0x0000000000000064) return KEYWORD_H_IMPORTED; // #imported
			// else if (x1 == 0x6564756C636E6923 && x2 == 0x0000000000000064) return KEYWORD_H_INCLUDED; // #included
			// else if (x1 == 0x5F64616572687423 && x2 == 0x0000006C61636F6C) return KEYWORD_H_THREAD_LOCAL; // #thread_local
		}
		else {
			// if (strings_are_equal(word, string("#on_function_exit"))) return KEYWORD_H_ON_FUNCTION_EXIT; // 17 = 3
			// if (strings_are_equal(word, string("#enable_function_names_list"))) return KEYWORD_H_ENABLE_FUNCTION_NAMES_LIST; // 27 = 4
		}
		return KEYWORD_NONE;
	}
	
	typedef struct {
		String name;
		Mfstr output;
	} Section;
	
	typedef struct {
		String fullpath;
		String path;
		String fullname;
		String name;
		String ext;
	} Pathinfo;
	
	typedef struct {
		Pathinfo pathinfo;
	} File;
	
	typedef struct {
		char* c;
		i64 i;
		i64 len;
		i64 line;
		u32 fileid;
	} Reader;
	
	typedef struct {
		char* c;
		i64 i;
		i64 line;
		i64 linestart;
		i64 linelength;
		String message;
	} Error;
	
	typedef struct TMFARR(String) Tmfarr_String;
	typedef struct TMFARR(Section) Tmfarr_Section;
	typedef struct TMFARR(File) Tmfarr_File;
	typedef struct TMFARR(Error) Tmfarr_Error;

// G

	Pathinfo inpath = {0};
	Pathinfo outpath = {0};
	
	Tmfarr_Section sections = {0};
	Tmfarr_File files = {0};
	Tmfarr_Error errors = {0};
	Tmfarr_String function_names = {0}; // const __function_id__ = 123;
	
	bool enable_function_names_list = true;

// helpers

	static int string_to_section (String a) {
		for (int i=1; i<sections.count; i++) {
			if (strings_are_equal(a,sections.data[i].name)) return i;
		}
		Section sec = {
			.name = os_mem_alloc_string(a),
			.output = mfstr_new(strings_are_equal(a,string("FUNCTIONS"))?1000000:100000),
		};
		tmfarr_append(&sections, &sec);
		return sections.count-1;
	}
	static Pathinfo parse_file_path (String fullpath) {
		Pathinfo f = {.fullpath = fullpath};
		for (int i=fullpath.length-1; i>=0; i--) {
			if (fullpath.data[i] == '/') {
				f.path.data = fullpath.data;
				f.path.length = i+1;
				// f.path.length = i;
				f.name.data = fullpath.data+i+1;
				f.name.length = fullpath.length-i-f.ext.length-2;
				f.fullname.data = fullpath.data+i+1;
				f.fullname.length = fullpath.length-i-1;
				break;
			}
			else if (fullpath.data[i] == '.' && !f.ext.length) {
				f.ext.data = fullpath.data+i+1;
				f.ext.length = fullpath.length-i-1;
			}
		}
		return f;
	}
	static bool is_escaped (char* start, char* c) {
		c --;
		bool escaped = false;
		while (c != start && *c == '\\') {
			escaped = !escaped;
			c --;
		}
		return escaped;
	}
	
	static void string_trim_trailing_whitespace (String* str) {
		while (str->length) {
			// if (str->data[str->length-1] <= ' ') {
			char c = str->data[str->length-1];
			if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
				str->length --;
			}
			else {
				break;
			}
		}
	}
	static void string_trim_leading_whitespace (String* str) {
		while (str->length) {
			// if (str->data[0] <= ' ') {
			char c = str->data[0];
			if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
				str->length --;
				str->data ++;
			}
			else {
				break;
			}
		}
	}
	static void string_trim_whitespace (String* str) {
		string_trim_trailing_whitespace(str);
		string_trim_leading_whitespace(str);
	}
	static String backslashes_to_forwardslashes (String path) {
		for (i64 i=0; i<path.length; i++) {
			if (path.data[i] == '\\') path.data[i] = '/';
		}
		return path;
	}
	static String remove_carriage_returns (String s) {
		char* c = s.data;
		u32 len = s.length;
		u32 r = 0;
		u32 w = 0;
		// Quickly find the first instance, that way no need to do anything if it doesn't exist.
		while (r < len) {
			if (c[r] == '\r') break;
			r ++;
		}
		w = r;
		// Do the thing.
		while (r < len) {
			if (c[r] == '\r') {
				r ++;
			}
			else {
				c[w] = c[r];
				r ++;
				w ++;
			}
		}
		// Fill the reduced space with zeroes.
		while (w < r) {
			c[w] = 0;
			w ++;
			s.length --;
		}
		return s;
	}
	static String trim_quotes (String s) {
		if (s.length < 2 || s.data[0] != '"' || s.data[s.length-1] != '"') return s;
		s.data ++;
		s.length -= 2;
		return s;
	}
	static String trim_whitespace (String s) {
		string_trim_whitespace(&s);
		return s;
	}
	
	static String __eat_string_single (String* s) {
		String word = {0};
		char* c = s->data;
		i64 len = s->length;
		i64 i = 0;
		
		while (i<len && (c[i]==' ' || c[i]=='\t' || c[i]=='\n' || c[i]=='\r')) i ++; // Skip all whitespace.
		
		if (i==len) {
			// Reached end, ignore everything.
		}
		else if (c[i] == '\'') { // String should be treated specially.
			i64 start = i;
			i ++; // Skip the opening quote.
			while (i<len && c[i]!='\'' && c[i-1]!='\\') i ++; // Go forward until another quote is reached, also make sure it isn't escaped with a backslash.
			if (c[i] == '\'') i ++; // Move past the end quote. This may not exist if there was no closing quote in the file.
			i64 end = i;
			word = (String){.data=c+start, .length=end-start};
		}
		
		s->data += i;
		s->length -= i;
		return word;
	}
	static String __eat_string (String* s) {
		String word = {0};
		char* c = s->data;
		i64 len = s->length;
		i64 i = 0;
		
		while (i<len && (c[i]==' ' || c[i]=='\t' || c[i]=='\n' || c[i]=='\r')) i ++; // Skip all whitespace.
		
		if (i==len) {
			// Reached end, ignore everything.
		}
		else if (c[i] == '"') {
			i64 start = i;
			i ++;// Skip the opening quote.
			while (i<len && (c[i]!='"' || c[i-1]=='\\')) i ++; // Go forward until another quote is reached, also make sure it isn't escaped with a backslash.
			if (c[i] == '"') i ++;// Move past the end quote. This may not exist if there was no closing quote in the file.
			word = (String){.data=c+start, .length=i-start};
		}
		
		s->data += i;
		s->length -= i;
		return word;
	}
	static String __eat_word (String* s) {
		String word = {0};
		char* c = s->data;
		i64 len = s->length;
		i64 i = 0;
		
		while (i<len && (c[i]==' ' || c[i]=='\t' || c[i]=='\n' || c[i]=='\r')) i ++; // Skip all whitespace.
		
		if (i==len) {
			// Reached end, ignore everything.
		}
		else { // Normal word.
			i64 start = i;
			while (i<len && (c[i]!=' ' && c[i]!='\t' && c[i]!='\n' && c[i]!='\r')) i ++; // Go forward until the next whitespace character.
			i64 end = i;
			while (end>start && (c[end-1]==' ' || c[end-1]=='\t' || c[end-1]=='\n' || c[end-1]=='\r')) end --; // Trim whitespace from the word. NOTE: this should not happen in the string method parser above.
			word = (String){.data=c+start, .length=end-start};
		}
		
		s->data += i;
		s->length -= i;
		return word;
	}
	static String __eat_thingy (String* s) {
		String word = {0};
		char* c = s->data;
		i64 len = s->length;
		i64 i = 0;
		
		while (i<len && (c[i]==' ' || c[i]=='\t' || c[i]=='\n' || c[i]=='\r')) i ++; // Skip all whitespace.
		
		if (i==len) {
			// Reached end, ignore everything.
		}
		else if (c[i] == '\'') { // String should be treated specially.
			i64 start = i;
			i ++; // Skip the opening quote.
			while (i<len && c[i]!='\'' && c[i-1]!='\\') i ++; // Go forward until another quote is reached, also make sure it isn't escaped with a backslash.
			if (c[i] == '\'') i ++; // Move past the end quote. This may not exist if there was no closing quote in the file.
			i64 end = i;
			word = (String){.data=c+start, .length=end-start};
		}
		else if (c[i] == '"') { // String should be treated specially.
			i64 start = i;
			i ++;// Skip the opening quote.
			while (i<len && c[i]!='"' && c[i-1]!='\\') i ++;// Go forward until another quote is reached, also make sure it isn't escaped with a backslash.
			if (c[i] == '"') i ++;// Move past the end quote. This may not exist if there was no closing quote in the file.
			i64 end = i;
			word = (String){.data=c+start, .length=end-start};
		}
		else { // Normal word.
			i64 start = i;
			while (i<len && (c[i]!=' ' && c[i]!='\t' && c[i]!='\n' && c[i]!='\r')) i ++; // Go forward until the next whitespace character.
			i64 end = i;
			while (end>start && (c[end-1]==' ' || c[end-1]=='\t' || c[end-1]=='\n' || c[end-1]=='\r')) end --; // Trim whitespace from the word. NOTE: this should not happen in the string method parser above.
			word = (String){.data=c+start, .length=end-start};
		}
		
		s->data += i;
		s->length -= i;
		return word;
	}
	
	static String create_relative_path (String a, String b) {
		if (a.length && a.data[a.length-1] == '/') a.length --;
		while (b.length >= 2 && *(u16*)b.data == *(u16*)"..") {
			while (a.length && a.data[a.length-1] != '/') a.length --;
			if (a.length) a.length --;
			
			b.data += 2;
			b.length -= 2;
			if (b.length && b.data[0] == '/') {
				b.data ++;
				b.length --;
			}
		}
		return vmem_string_from_strings(a, string("/"), b);
	}
	static String create_path_relative_to_inpath (String a) {
		i64 i = 0;
		i64 len = (a.length < inpath.path.length) ? a.length : inpath.path.length;
		while (i<len) {
			if (a.data[i] != inpath.path.data[i]) break;
			i ++;
		}
		a.length -= i;
		a.data += i;
		return a;
	}

// parsing

	static void add_error (Reader* reader, int startpos, char* message) {
		Error e = {
			.c = reader->c,
			.i = reader->i,
			.linestart = reader->i,
			.message = vmem_alloc_string(string(message)),
		};
		
		// int find_line_count (char* c, int i) {
		// 	int line = 0;
		// 	while (i) {
		// 		if (c[i] == '\n') line ++;
		// 		i --;
		// 	}
		// 	return line;
		// }
		
		// Find current line bounds.
		if (e.linestart > 0) {
			if (e.c[e.linestart] == '\n') e.linestart --;
			while (e.linestart) {
				if (e.c[e.linestart] == '\n') {
					e.linestart ++;
					break;
				}
				e.linestart --;
			}
		}
		int i = e.i;
		while (i<reader->len && e.c[i] != '\n') i ++;
		e.linelength = i-e.linestart;
		
		// Find line count.
		i = e.linestart;
		while (i) {
			if (e.c[i] == '\n') e.line ++;
			i --;
		}
		
		File* file = files.data+reader->fileid;
		printf("----[ERROR]----\n");
		printf("    File: %.*s\n", file->pathinfo.fullpath.length, file->pathinfo.fullpath.data);
		printf("    Row %i, column %i, byte %i, startbyte %i\n", e.line, e.i-e.linestart, e.i, startpos);
		printf("    Reason: %s\n", message);
		printf("    Line: %.*s\n", e.linelength,e.c+e.linestart);
		printf("---------------\n");
		tmfarr_append(&errors, &e);
	}
	
	static String charliteral_to_hex (Reader* r, String lit) {
		if (lit.length <= 2 || lit.data[0] != '\'' || lit.data[lit.length-1] != '\'') {
			lprintf_error("Invalid char literal... this is a compiler bug? Doesn't happen in reality?\n");
			return (String){0};
		}
		lit.data += 1;
		lit.length -= 2;
		
		const char* hex = "0123456789ABCDEF";
		
		char buf [2 + 8*2] = {0};
		int i = sizeof(buf)-1;
		
		while (lit.length) {
			if (i == 0) { add_error(r, r->i, "Char literal too long, max is 8 bytes."); return (String){0}; }
			
			if (*lit.data == '\\') {
				lit.data ++; lit.length --;
				// Note: there has to be character after this, the character literal parser should have caught an errors if not.
				
				switch (*lit.data) {
					case '0': buf[i]='0'; i--; buf[i]='0'; i--; break;
					case 'a': buf[i]='7'; i--; buf[i]='0'; i--; break;
					case 'b': buf[i]='8'; i--; buf[i]='0'; i--; break;
					case 't': buf[i]='9'; i--; buf[i]='0'; i--; break;
					case 'n': buf[i]='A'; i--; buf[i]='0'; i--; break;
					case 'v': buf[i]='B'; i--; buf[i]='0'; i--; break;
					case 'f': buf[i]='C'; i--; buf[i]='0'; i--; break;
					case 'r': buf[i]='D'; i--; buf[i]='0'; i--; break;
					case '\'': buf[i]='7'; i--; buf[i]='2'; i--; break;
					case '\\': buf[i]='C'; i--; buf[i]='5'; i--; break;
					case 'x': {
						lit.data ++; lit.length --;
						if (lit.length < 2) { add_error(r, r->i, "Hex code in char literal doesn't have enough characters, only exactly 2 are supported."); return (String){0}; }
						
						char x = *lit.data;
						lit.data ++; lit.length --;
						char y = *lit.data;
						// lit.data ++; lit.length --; // Done below outside the switch.
						
						if (!((x >= '0' && x <= '9') || (x >= 'A' && x <= 'F') || (x >= 'a' && x <= 'f'))) { add_error(r, r->i, "Hex code in char literal requires 2 valid hex characters (0123456789ABCDEFabcdef). First character is not."); return (String){0}; }
						if (!((y >= '0' && y <= '9') || (y >= 'A' && y <= 'F') || (y >= 'a' && y <= 'f'))) { add_error(r, r->i, "Hex code in char literal requires 2 valid hex characters (0123456789ABCDEFabcdef). Second character is not."); return (String){0}; }
						
						buf[i] = y; i --;
						buf[i] = x; i --;
						
						break;
					}
					default: { add_error(r, r->i, "Unsupported escape sequence in char literal. Allowed: 0abtnvfrx'\\"); return (String){0}; }
				}
				lit.data ++; lit.length --;
			}
			else {
				u8 x = *(u8*)lit.data;
				u8 y = x >> 4;
				x = x & 0xF;
				y = y & 0xF;
				buf[i] = hex[x]; i --;
				buf[i] = hex[y]; i --;
				lit.data ++; lit.length --;
			}
		}
		
		buf[i] = 'x'; i --;
		buf[i] = '0';
		
		lit.data = buf+i;
		lit.length = sizeof(buf)-i;
		return vmem_alloc_string(lit);
	}
	
	static void skip_known_line_comment (Reader* reader) {
		Reader r = *reader;
		r.i += 2;
		while (r.i < r.len) {
			if (r.c[r.i] == '\n') {
				if (is_escaped(r.c, r.c+r.i)) {
					add_error(&r, r.i-1, "Backslash-escaped line comments not allowed.");
					*reader = r;
					return;
				}
				
				r.line ++;
				r.i ++;
				break;
			}
			r.i ++;
		}
		*reader = r;
	}
	static void skip_known_block_comment (Reader* reader) {
		Reader r = *reader;
		r.i += 2;
		while (r.i < r.len) {
			if (r.c[r.i] == '*' && r.c[r.i+1] == '/') {
				r.i += 2;
				break;
			}
			else if (r.c[r.i] == '\n') {
				r.line ++;
			}
			r.i ++;
		}
		*reader = r;
	}
	static void skip_whitespace (Reader* reader) {
		Reader r = *reader;
		while (r.i < r.len) {
			if (r.c[r.i] == ' ' || r.c[r.i] == '\t') {
				r.i ++;
			}
			else if (r.c[r.i] == '\n') {
				r.i ++;
				r.line ++;
			}
			else if (r.c[r.i] == '/') {
				// Comments.
				if (r.c[r.i+1] == '/') {
					skip_known_line_comment(&r);
				}
				else if (r.c[r.i+1] == '*') {
					skip_known_block_comment(&r);
				}
				else {
					break;
				}
			}
			else {
				break;
			}
		}
		*reader = r;
	}
	static void skip_whitespace_nonewlines (Reader* reader) {
		Reader r = *reader;
		while (r.i < r.len) {
			if (r.c[r.i] == ' ' || r.c[r.i] == '\t') {
				r.i ++;
			}
			else if (r.c[r.i] == '\n') {
				if (is_escaped(r.c, r.c+r.i)) {
					// TODO: check if this is used correctly probably noy
					add_error(&r, r.i-1, "No new lines allowed here!");
					*reader = r;
					return;
				}
				break;
			}
			else if (r.c[r.i] == '/') {
				// Comments.
				if (r.c[r.i+1] == '/') {
					r.i += 2;
					while (r.i < r.len) {
						if (r.c[r.i] == '\n') break;
						r.i ++;
					}
					break;
				}
				else if (r.c[r.i+1] == '*') {
					r.i += 2;
					while (r.i < r.len) {
						if (r.c[r.i] == '\n') {
							add_error(&r, r.i, "Lines breaks not allowed inside block comments in this context.");
							*reader = r;
							return;
						}
						if (r.c[r.i] == '*' && r.c[r.i+1] == '/') {
							r.i += 2;
							break;
						}
						r.i ++;
					}
				}
				else {
					break;
				}
			}
			else {
				break;
			}
		}
		*reader = r;
	}
	static String eat_string (Reader* reader, int* out__calculatedlength) {
		Reader r = *reader;
		
		int calculatedlength = 0;
		
		String v = {0};
		if (r.c[r.i] != '"') {
			add_error(&r, r.i, "Expected quoted string.");
			*reader = r;
			return v;
		}
		int start = r.i;
		r.i ++;
		while (r.i<r.len) {
			if (r.c[r.i] == '"' && !is_escaped(r.c, r.c+r.i)) {
				break;
			}
			else if (r.c[r.i] == '\n') {
				add_error(&r, start, "Line breaks not allowed inside strings. I'd allow it but I can't fix syntax highlighting in editor.");
				*reader = r;
				return v;
			}
			else if (r.c[r.i] == '\\') {
				r.i ++;
				calculatedlength ++;
				
				switch (r.c[r.i]) {
					case '0': r.i ++; break;
					case 'a': r.i ++; break;
					case 'b': r.i ++; break;
					case 't': r.i ++; break;
					case 'n': r.i ++; break;
					case 'v': r.i ++; break;
					case 'f': r.i ++; break;
					case 'r': r.i ++; break;
					case '"': r.i ++; break;
					case '\\': r.i ++; break;
					case 'x': {
						r.i ++;
						if (r.i+2 >= r.len) {
							add_error(&r, r.i, "Hex code '0x' in string doesn't have enough characters, only exactly 2 are supported.");
							*reader = r;
							return v;
						}
						
						char x = r.c[r.i];
						r.i ++;
						char y = r.c[r.i];
						r.i ++;
						
						if (!((x >= '0' && x <= '9') || (x >= 'A' && x <= 'F') || (x >= 'a' && x <= 'f'))) {
							add_error(&r, r.i, "Hex code in string requires 2 valid hex characters (0123456789ABCDEFabcdef). First character is not.");
							*reader = r;
							return v;
						}
						if (!((y >= '0' && y <= '9') || (y >= 'A' && y <= 'F') || (y >= 'a' && y <= 'f'))) {
							add_error(&r, r.i, "Hex code in string requires 2 valid hex characters (0123456789ABCDEFabcdef). Second character is not.");
							*reader = r;
							return v;
						}
						
						break;
					}
					default: {
						add_error(&r, r.i, "Unsupported escape sequence in string. Allowed: 0abtnvfrx\\\"'");
						*reader = r;
						return v;
					}
				}
			}
			else {
				calculatedlength ++;
				r.i ++;
			}
		}
		if (r.c[r.i] != '"') {
			add_error(&r, start, "String never ended.");
			*reader = r;
			return v;
		}
		r.i ++;
		v.data = r.c+start;
		v.length = r.i-start;
		if (out__calculatedlength) *out__calculatedlength = calculatedlength;
		
		*reader = r;
		return v;
	}
	static String eat_charliteral (Reader* reader) {
		Reader r = *reader;
		
		String v = {0};
		if (r.c[r.i] != '\'') {
			add_error(&r, r.i, "Expected character literal.");
			*reader = r;
			return v;
		}
		int start = r.i;
		r.i ++;
		while (r.i<r.len) {
			if (r.c[r.i] == '\'' && !is_escaped(r.c, r.c+r.i)) break;
			if (r.c[r.i] == '\n') {
				add_error(&r, r.i, "Line breaks not allowed inside character literals.");
				*reader = r;
				return v;
			}
			if (r.c[r.i] < ' ' || r.c[r.i] > '~') {
				add_error(&r, r.i, "Non-printable byte found in char literal.");
				*reader = r;
				return v;
			}
			r.i ++;
		}
		if (r.c[r.i] != '\'' || is_escaped(r.c, r.c+r.i)) {
			add_error(&r, r.i, "Character literal never ended.");
			*reader = r;
			return v;
		}
		r.i ++;
		if (r.i == start+2) {
			add_error(&r, r.i, "Empty character literal.");
			*reader = r;
			return v;
		}
		v.data = r.c+start;
		v.length = r.i-start;
		
		*reader = r;
		return v;
	}
	static String eat_word (Reader* reader) {
		Reader r = *reader;
		
		int start = r.i;
		String v = {0};
		if ((r.c[r.i] >= 'a' && r.c[r.i] <= 'z') || (r.c[r.i] >= 'A' && r.c[r.i] <= 'Z') || r.c[r.i] == '_' || r.c[r.i] == '#') {
			r.i ++;
			while (r.i<r.len) {
				if ((r.c[r.i] >= 'a' && r.c[r.i] <= 'z') || (r.c[r.i] >= 'A' && r.c[r.i] <= 'Z') || (r.c[r.i] >= '0' && r.c[r.i] <= '9') || r.c[r.i] == '_') r.i ++;
				else break;
			}
			v.data = r.c+start;
			v.length = r.i-start;
		}
		
		*reader = r;
		return v;
	}
	static String get_word (Reader* reader) {
		Reader r = *reader;
		
		int start = r.i;
		String v = {0};
		if ((r.c[r.i] >= 'a' && r.c[r.i] <= 'z') || (r.c[r.i] >= 'A' && r.c[r.i] <= 'Z') || r.c[r.i] == '_' || r.c[r.i] == '#') {
			r.i ++;
			while (r.i<r.len) {
				if ((r.c[r.i] >= 'a' && r.c[r.i] <= 'z') || (r.c[r.i] >= 'A' && r.c[r.i] <= 'Z') || (r.c[r.i] >= '0' && r.c[r.i] <= '9') || r.c[r.i] == '_') r.i ++;
				else break;
			}
			v.data = r.c+start;
			v.length = r.i-start;
		}
		
		return v;
	}
	/*static KEYWORD string_to_keyword_or_return_word (Reader* reader, String word) {
		KEYWORD keyword = string_to_keyword(word);
		if (!keyword) reader->i -= word.length;
		return keyword;
	}*/
	/*static String eat_number (Reader* reader) {
		Reader r = *reader;
		
		String v = {0};
		int start = r.i;
		if (r.c[r.i] == '0' && r.c[r.i+1] == 'x') {
			r.i += 2;
			while (r.i<r.len) {
				if ((r.c[r.i] >= 'a' && r.c[r.i] <= 'f') || (r.c[r.i] >= 'A' && r.c[r.i] <= 'F') || (r.c[r.i] >= '0' && r.c[r.i] <= '9') || r.c[r.i] == '_') r.i ++;
				else break;
			}
		}
		else if (r.c[r.i] == '0' && r.c[r.i+1] == 'b') {
			r.i += 2;
			while (r.i<r.len) {
				if (r.c[r.i] == '0' || r.c[r.i] == '1' || r.c[r.i] == '_') r.i ++;
				else break;
			}
		}
		else if ((r.c[r.i] >= '0' && r.c[r.i] <= '9') || r.c[r.i] == '-' || r.c[r.i] == '.') {
			bool nega = false;
			bool decimal = false;
			if (r.c[r.i] == '-') {
				r.i ++;
				nega = true;
			}
			if (r.c[r.i] == '0') {
				r.i ++;
				if ((r.c[r.i] >= '0' && r.c[r.i] <= '9') || r.c[r.i] == '.') {
					add_error(&r, r.i, "Number that starts with 0 cannot have other numbers after it. Valid zero-starts: 0 / 0. / 0x / 0b");
					*reader = r;
					return v;
				}
			}
			while (r.i<r.len) {
				if (r.c[r.i] >= '0' && r.c[r.i] <= '9') {
					r.i ++;
				}
				else if (r.c[r.i] == '.') {
					if (decimal) {
						add_error(&r, r.i, "Number has multiple decimal points.");
						*reader = r;
						return v;
					}
					decimal = true;
					r.i ++;
				}
				else break;
			}
		}
		else {
			add_error(&r, r.i, "Number expected.");
		}
		if (r.i==start) {
			add_error(&r, r.i, "Number expected.");
			*reader = r;
			return v;
		}
		v.length = r.i-start;
		v.data = r.c+start;
		
		*reader = r;
		return v;
	}*/
	
	static Errnum do_file (String path) {
		for (i64 f=0; f<files.count; f++) {
			if (strings_are_equal(files.data[f].pathinfo.fullpath, path)) {
				return 0;
			}
		}
		
		String filedata = remove_carriage_returns(os_read_entire_file(path));
		if (!filedata.data) {
			return 1;
		}
		
		u32 fileid = files.count;
		File file = {
			.pathinfo = parse_file_path(vmem_alloc_string(path)),
		};
		tmfarr_append(&files, &file);
		// printf("Imported new file [%.*s]\n", path.length, path.data);
		
		Reader r = {
			.c = filedata.data,
			.i = 0,
			.len = filedata.length,
			.line = 0,
			.fileid = fileid,
		};
		i64 section = 0;
		i64 last_write_pos = 0;
		
		while (r.i < r.len) {
			if (r.c[r.i] == '\t' || r.c[r.i] == ' ' || r.c[r.i] == '\n') {
				skip_whitespace(&r);
			}
			else if (r.c[r.i] == '/') {
				// Comments.
				if (r.c[r.i+1] == '/') {
					skip_known_line_comment(&r);
				}
				else if (r.c[r.i+1] == '*') {
					skip_known_block_comment(&r);
				}
				else {
					r.i ++;
				}
			}
			else if (r.c[r.i] == '"' || r.c[r.i] == '\'') {
				mfstr_append(&sections.data[section].output, r.i-last_write_pos, r.c+last_write_pos);
				if (r.c[r.i] == '"') {
					int slen = 0;
					String sl = eat_string(&r, &slen);
					char p = sl.data[-2];
					if (sl.data[-1] == 'S' && !((p>='a'&&p<='z')||(p>='A'&&p<='Z')||(p>='0'&&p<='9')||p=='_')) {
						sections.data[section].output.length --;
						mfstr_append(&sections.data[section].output, string("((String){.length="));
						mfstr_append_int(&sections.data[section].output, slen);
						mfstr_append(&sections.data[section].output, string(",.data="));
						mfstr_append(&sections.data[section].output, sl);
						mfstr_append(&sections.data[section].output, string("})"));
					}
					else {
						mfstr_append(&sections.data[section].output, sl);
					}
					// if (sl.data[-1] == '_' && !((p>='a'&&p<='z')||(p>='A'&&p<='Z')||(p>='0'&&p<='9')||p=='_')) {
					// 	sections.data[section].output.length --;
					// 	mfstr_append(&sections.data[section].output, sl);
					// }
					// else {
					// 	mfstr_append(&sections.data[section].output, string("((String){.length="));
					// 	mfstr_append_int(&sections.data[section].output, slen);
					// 	mfstr_append(&sections.data[section].output, string(",.data="));
					// 	mfstr_append(&sections.data[section].output, sl);
					// 	mfstr_append(&sections.data[section].output, string("})"));
					// }
				}
				else if (r.c[r.i] == '\'') {
					String cl = eat_charliteral(&r);
					String hex = charliteral_to_hex(&r, cl);
					mfstr_append(&sections.data[section].output, hex);
				}
				last_write_pos = r.i;
			}
			else if (r.c[r.i] == '#') {
				i64 keywordstart = r.i;
				KEYWORD keyword = string_to_keyword(eat_word(&r));
				if (keyword == KEYWORD_H_SECTION) {
					skip_whitespace_nonewlines(&r);
					
					if (keywordstart == 0 || r.c[keywordstart-1] != '\n') {
						add_error(&r, r.i, "#section must start on a new line, correct syntax: \\n#section FOO;\\n");
						return 0;
					}
					String word = eat_word(&r);
					if (!word.length) {
						add_error(&r, r.i, "#section must have a name, correct syntax: \\n#section FOO;\\n");
						return 0;
					}
					if (r.i==r.len || r.c[r.i] != ';') {
						add_error(&r, r.i, "#section name must be followed by a semicolon, correct syntax: \\n#section FOO;\\n");
						return 0;
					}
					r.i ++;
					if (r.i==r.len || r.c[r.i] != '\n') {
						add_error(&r, r.i, "#section must end with a new line, correct syntax: \\n#section FOO;\\n");
						return 0;
					}
					r.i ++;
					r.line ++;
					
					mfstr_append(&sections.data[section].output, keywordstart-last_write_pos, r.c+last_write_pos);
					last_write_pos = r.i;
					section = string_to_section(word);
					
					mfstr_append(&sections.data[section].output, string("\n#line "));
					mfstr_append_int(&sections.data[section].output, r.line+1);
					mfstr_append(&sections.data[section].output, string(" \""));
					mfstr_append(&sections.data[section].output, create_path_relative_to_inpath(file.pathinfo.fullpath));
					mfstr_append(&sections.data[section].output, string("\"\n"));
				}
				else if (keyword == KEYWORD_H_IMPORT) {
					skip_whitespace_nonewlines(&r);
					
					String impath = trim_whitespace(trim_quotes(eat_string(&r, NULL)));
					if (!impath.length) {
						add_error(&r, r.i, "Invalid #import path, correct syntax: #import \"foo.c\"\\n");
						return 0;
					}
					if (r.i==r.len || r.c[r.i] != '\n') {
						add_error(&r, r.i, "#import must end with a new line, correct syntax: #import \"foo.c\"\\n");
						return 0;
					}
					// r.i ++;
					// r.line ++;
					
					mfstr_append(&sections.data[section].output, keywordstart-last_write_pos, r.c+last_write_pos);
					last_write_pos = r.i;
					
					Errnum e = do_file(create_relative_path(file.pathinfo.path, backslashes_to_forwardslashes(impath)));
					if (e) {
						add_error(&r, r.i, vmem_alloc_print("Failed to open #imported file [%.*s].", impath.length, impath.data));
						return 0;
					}
				}
			}
			else {
				r.i ++;
			}
		}
		mfstr_append(&sections.data[section].output, r.i-last_write_pos, r.c+last_write_pos);
		
		files.data[fileid] = file;
		return 0;
	}
	int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, char* pCmdLine, int nCmdShow) {
		vmem_ez_init(os_get_system_memory_size()/4, 1024*1024*8);
		
		if (!pCmdLine) {
			printf("SBC: no program arguments, expected: ntn.exe \"input.c\" \"output.c\"\n");
			return 1;
		}
		String args = string(pCmdLine);
		
		inpath = parse_file_path(backslashes_to_forwardslashes(vmem_alloc_string(trim_quotes(__eat_string(&args)))));
		if (!inpath.fullpath.length || !inpath.fullname.length) {
			printf("SBC: no input path, expected: ntn.exe \"input.c\" \"output.c\"\n");
			return 2;
		}
		
		outpath = parse_file_path(backslashes_to_forwardslashes(vmem_alloc_string(trim_quotes(__eat_string(&args)))));
		if (!outpath.fullpath.length || !outpath.name.length) {
			printf("SBC: no output path, expected: ntn.exe \"input.c\" \"output.c\"\n");
			return 3;
		}
		
		// printf("IN [%.*s]\nOUT [%.*s]\n", inpath.fullpath.length, inpath.fullpath.data, outpath.fullpath.length, outpath.fullpath.data);
		
		sections = tmfarr_new(Tmfarr_Section, 16);
			Section sec = {
				.name = os_mem_alloc_string(string("__UNNAMED_SECTION__")),
				.output = mfstr_new(100000),
			};
			tmfarr_append(&sections, &sec);
		files = tmfarr_new(Tmfarr_File, 256);
		// functions = tmfarr_new(Tmfarr_Function, 1024);
		
		Errnum e = do_file(inpath.fullpath);
		if (e == 1) {
			printf("Failed to open start file [%.*s]!\n", inpath.fullpath.length, inpath.fullpath.data);
			return 4;
		}
		else if (errors.count) {
			return 5;
		}
		
		i64 outlength = strlen("// SBC IMPORTED FILES\n\n// SBC META\nconst unsigned long __func_count__=99999;\nconst char* __func_names__[]={\n\"__INVALID__\"\n};\n");
		// for (i64 i=0; i<functions.count; i++) {
		// 	outlength += strlen("// \n") + functions.data[i].name.length;
		// 	outlength += strlen(",\"\"") + functions.data[i].name.length;
		// }
		for (i64 i=0; i<files.count; i++) {
			outlength += strlen("// \n") + files.data[i].pathinfo.fullpath.length;
		}
		for (i64 i=0; i<sections.count; i++) {
			outlength += strlen("\n// SBC SECTION \n") + sections.data[i].name.length + sections.data[i].output.length;
		}
		Mfstr output = mfstr_new(outlength);
		
		mfstr_append(&output, "// SBC IMPORTED FILES\n");
		for (i64 i=0; i<files.count; i++) {
			mfstr_append(&output, "// ");
			mfstr_append(&output, create_path_relative_to_inpath(files.data[i].pathinfo.fullpath));
			mfstr_append(&output, "\n");
		}
		// mfstr_append(&output, "\n// SBC META\n");
		// mfstr_append(&output, "const unsigned long __func_count__=");
		// mfstr_append_int(&output, (functions.count) ? functions.count+1 : 0);
		// mfstr_append(&output, ";");
		// if (enable_function_names_list) {
		// 	mfstr_append(&output, "\nconst char* __func_names__[]={\n\"__INVALID__\"");
		// 	for (i64 i=0; i<functions.count; i++) {
		// 		mfstr_append(&output, ",\"");
		// 		mfstr_append(&output, functions.data[i].name);
		// 		mfstr_append(&output, "\"");
		// 	}
		// 	mfstr_append(&output, "\n};\n");
		// }
		for (i64 i=0; i<sections.count; i++) {
			mfstr_append(&output, "\n// SBC SECTION ");
			mfstr_append(&output, sections.data[i].name);
			mfstr_append(&output, "\n");
			mfstr_append(&output, sections.data[i].output.string);
		}
		
		os_write_to_file(outpath.fullpath, 0, output.length, output.data, OS_FILE_REMOVE_OLD_DATA);
		
		return 0;
	}
