/*
	https://docs.microsoft.com/en-us/windows/win32/debug/system-error-codes--0-499-
*/
	#define UNICODE 1
	#define _UNICODE 1
	#define WIN32_LEAN_AND_MEAN 1
	#define VC_EXTRALEAN 1
	#include <windows.h>
	#undef VC_EXTRALEAN
	#undef WIN32_LEAN_AND_MEAN
	#undef UNICODE
	#undef _UNICODE

// Wide char string dickery because Windows was temporarily shit (newer versions seem to just werk with utf8, but old versions need all wide char variations of everything).

	#define WIN_MAX_PATH 1024
	
	#define STRING_TO_WSTR_N(name, maxcount, str) \
		WCHAR name [maxcount+1]; \
		int name##_widecharacters = MultiByteToWideChar(CP_UTF8, 0, (str).data, (str).length, name, maxcount); \
		name[name##_widecharacters] = 0;
	
	#define WSTR_TO_ALLOCATED_MBSTR(name, widestr, add) \
		int name##_widecharacters = wcslen(widestr); \
		int name##_mbbytes = WideCharToMultiByte(CP_UTF8, 0, widestr, name##_widecharacters, NULL, 0, NULL, NULL); \
		char* name = os_mem_alloc(name##_mbbytes+add+1); \
		WideCharToMultiByte(CP_UTF8, 0, widestr, name##_widecharacters, name, name##_mbbytes+1, NULL, NULL); \
		name[name##_mbbytes] = 0;

// meme

	static u64 os_mem_free (void* mem) {
		return HeapFree(GetProcessHeap(), 0, mem);
	}
	static void* os_mem_alloc (u64 amount) {
		return HeapAlloc(GetProcessHeap(), 0, amount);
	}
	static void* os_mem_alloc_zeroed (u64 amount) {
		return HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, amount);
	}
	static void* os_mem_realloc (void* mem, u64 amount) {
		return HeapReAlloc(GetProcessHeap(), 0, mem, amount);
	}
	static String os_mem_alloc_string (String str) {
		char* cursor = os_mem_alloc(str.length+1);
		if (cursor) {
			mem_copy(cursor, str.length, str.data);
			cursor[str.length] = 0;
			str.data = cursor;
		}
		else {
			str = (String){0};
		}
		return str;
	}
	
	static u64 os_mem_get_page_size (void) {
		SYSTEM_INFO info;
		GetSystemInfo(&info);
		return info.dwPageSize;
	}
	static void* os_mem_reserve_virtual_address_space (u64 amount) {
		return VirtualAlloc(NULL, amount, MEM_RESERVE, PAGE_READWRITE);
	}
	static Errnum os_mem_free_virtual_address_space (void* mem) {
		BOOL result = VirtualFree(mem, 0, MEM_RELEASE);
		return (result) ? 0 : 1;
	}
	static Errnum os_mem_commit_virtual_memory (void* mem, u64 amount) {
		// Could return the result, but it should be the same as mem anyway?
		void* result = VirtualAlloc(mem, amount, MEM_COMMIT, PAGE_READWRITE);
		return (result) ? 0 : 1;
	}
	static Errnum os_mem_decommit_virtual_memory (void* mem, u64 amount) {
		BOOL result = VirtualFree(mem, amount, MEM_DECOMMIT);
		return (result) ? 0 : 1;
	}
	static Errnum os_mem_shrink_virtual_memory (void* mem, u64 address_space_size, u64 new_commit_amount) {
		BOOL result = VirtualFree(mem+new_commit_amount, address_space_size-new_commit_amount, MEM_DECOMMIT);
		return (result) ? 0 : 1;
	}

// file system

	typedef enum : u8 {
		OS_FILE_ONLY_EXISTING = 0x1,
		OS_FILE_ONLY_NEW = 0x2,
		OS_FILE_REMOVE_OLD_DATA = 0x4,
		OS_FILE_ALLOW_OVERWRITE_OF_EXISTING = 0x8,
	} OS_FILE_FLAGS;
	
	static bool os_file_exists (String filepath) {
		STRING_TO_WSTR_N(wpath, WIN_MAX_PATH, filepath)
		
		HANDLE file = CreateFileW(wpath, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE|FILE_SHARE_DELETE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file == INVALID_HANDLE_VALUE) return false;
		
		CloseHandle(file);
		
		return true;
	}
	static String os_read_entire_file (String filepath) {
		// Note: The buffer size will be aligned to 64 bytes AND have at least 64 extra zeroes at the end, so it should be safe to read with SIMD. The .size property doesn't include null terminator.
		STRING_TO_WSTR_N(wpath, WIN_MAX_PATH, filepath)
		
		HANDLE file = CreateFileW(wpath, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file == INVALID_HANDLE_VALUE) return (String){0};
		
		String buffer = {0};
		
		LARGE_INTEGER s;
		BOOL success = GetFileSizeEx(file, &s);
		if (success) {
			buffer.length = s.QuadPart;
			u64 datasize = buffer.length + ((buffer.length+1) % 64) + 64;
			buffer.data = os_mem_alloc(datasize);
			
			DWORD bytesread = 0;
			BOOL success = ReadFile(file, buffer.data, buffer.length, &bytesread, NULL);
			// TODO? handle a situation where all bytes weren't read
			if (!success) {
				os_mem_free(buffer.data);
				buffer = (String){0};
			}
			else {
				// Fill the remainder space with 0s
				for (u64 i=buffer.length; i<datasize; i++) {
					((char*)(buffer.data))[i] = 0;
				}
			}
		}
		
		CloseHandle(file);
		
		return buffer;
	}
	static void os_free_file_data (String* buffer) {
		if (buffer->data) os_mem_free(buffer->data);
		*buffer = (String){0};
	}
	static Errnum os_write_to_file (String filepath, u64 pos, u64 datalength, void* data, OS_FILE_FLAGS optionflags) {
		STRING_TO_WSTR_N(wpath, WIN_MAX_PATH, filepath)
		
		DWORD method;
		if (optionflags & OS_FILE_ONLY_NEW) {
			method = CREATE_NEW;
		}
		else if (optionflags & OS_FILE_ONLY_EXISTING) {
			method = (optionflags & OS_FILE_REMOVE_OLD_DATA) ? OPEN_EXISTING : TRUNCATE_EXISTING;
		}
		else {
			method = (optionflags & OS_FILE_REMOVE_OLD_DATA) ? CREATE_ALWAYS : OPEN_ALWAYS;
		}
		
		HANDLE file = CreateFileW(wpath, GENERIC_WRITE, 0, NULL, method, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file == INVALID_HANDLE_VALUE) return 1;
		
		Errnum e = 0;
		
		if (pos) {
			LARGE_INTEGER p = {.QuadPart=pos};
			BOOL success = SetFilePointerEx(file, p, NULL, FILE_BEGIN);
			if (!success) {
				e = 2;
			}
		}
		if (!e) {
			DWORD byteswritten = 0;
			BOOL success = WriteFile(file, data, datalength, &byteswritten, NULL);
			if (!success) {
				e = 3;
			}
			// TODO: handle a situation where all bytes weren't written? Is it even possible under normal circumstances?
		}
		
		CloseHandle(file);
		
		return e;
	}
	static Errnum os_delete_file (String filepath) {
		STRING_TO_WSTR_N(wpath, WIN_MAX_PATH, filepath)
		BOOL success = DeleteFileW(wpath);
		if (!success) {
			if (GetLastError() == ERROR_FILE_NOT_FOUND) return 0;
			return 1;
		}
		return 0;
	}

// main

	static u32 os_get_cpu_core_count (void) {
		SYSTEM_INFO sysInfo;
		GetSystemInfo(&sysInfo);
		return sysInfo.dwNumberOfProcessors;
	}
	static u64 os_get_system_memory_size (void) {
		ULONGLONG m;
		GetPhysicallyInstalledSystemMemory(&m);
		return m*1024;
	}
	static String os_get_program_path (void) {
		static String result = {0};
		
		if (!result.data) {
			WCHAR widestr [WIN_MAX_PATH+1];
			GetModuleFileNameW(NULL, widestr, WIN_MAX_PATH);
			
			WSTR_TO_ALLOCATED_MBSTR(path, widestr, 2)
			for (int i=0; i<path_mbbytes; i++) {
				if (path[i] == '\\') path[i] = '/';
			}
			
			// Includes exe name, remove it.
			for (int i=path_mbbytes-1; i>=0; i--) {
				if (path[i] == '/') {
					path_mbbytes = i;
					break;
				}
			}
			
			// Normalize path.
			while (path_mbbytes && path[path_mbbytes-1] == '/') {
				path_mbbytes --;
			}
			path[path_mbbytes] = '/'; path_mbbytes += 1;
			path[path_mbbytes] = 0;
			
			result.length = path_mbbytes;
			result.data = path;
		}
		
		return result;
	}
	static String os_get_program_exe_name (void) {
		static String result = {0};
		
		if (!result.data) {
			WCHAR wpath [WIN_MAX_PATH+8];
			GetModuleFileNameW(NULL, wpath, WIN_MAX_PATH);
			
			WSTR_TO_ALLOCATED_MBSTR(name, wpath, 0)
			for (int i=name_mbbytes-1; i>=0; i--) {
				if (name[i] == '\\' || name[i] == '/') {
					name_mbbytes = name_mbbytes-i-1;
					mem_move(name, name_mbbytes, name+i+1);
					name[name_mbbytes] = 0;
					break;
				}
			}
			result.length = name_mbbytes;
			result.data = name;
		}
		
		return result;
	}
	static String os_get_program_working_directory (void) {
		static String result = {0};
		
		if (!result.data) {
			WCHAR wpath [WIN_MAX_PATH+8];
			DWORD len = GetCurrentDirectoryW(WIN_MAX_PATH, wpath);
			
			WSTR_TO_ALLOCATED_MBSTR(path, wpath, 1)
			
			// Normalize path.
			for (int i=0; i<path_mbbytes; i++) {
				if (path[i] == '\\') path[i] = '/';
			}
			while (path_mbbytes && path[path_mbbytes-1] == '/') {
				path_mbbytes --;
			}
			path[path_mbbytes] = '/'; path_mbbytes += 1;
			path[path_mbbytes] = 0;
			
			result.length = path_mbbytes;
			result.data = path;
		}
		
		return result;
	}
