@ECHO OFF

rem Config.

	set build_release=1
	set build_dev=2
	set build_debug=3
	set build_type=%build_release%
	set gcc=C:\MinGW\bin\gcc.exe
	
	IF %build_type%==%build_dev% (
		set exename=sbc_DEV
	) ELSE IF %build_type%==%build_debug% (
		set exename=sbc_DEBUG
	) ELSE (
		set exename=sbc
	)
	
	rem Note: -pedantic is desireable in theory, but it forbids "nested functions", which I assume means a function that uses variables from the parent scope. I use these effectively as macros so fuck you.
	rem strict-prototypes = functions must define something in the arguments, if it takes no arguments then it must have "void" in it. There's an edge case that's still a bit wrong though: if the function is declared earlier with "void", it can still be defined with an empty arguments list. The function won't accept arguments though [it would without strict-prototypes], it just looks wrong.
	rem return-type warns if functions don't return values correctly
	rem inline should warn when an inline function cannot be inlined for some reason, there's some kinds of things that make it unsuitable for inlining.
	rem fallthrough requires the usage of __attribute__ fallthrough for switch cases. This stops you from accidentally falling through switch cases.
	rem conversion forbids implicit type conversion if there may be loss of information.
	rem pointer-arith = forbids offsetting void pointers which is fucking gay and retarded.
	rem dangling-else = complains about single line'd if/else chains because they're """suspicious""".
	rem format = complains about incompatible printf inputs, good in theory but downright broken in practice. It doesn't recognize %lli, and who cares what specific int type some fucking Windows "WPARAM" value is.
	rem unused-function, unused-value, unused-variable, unused-but-set-variable, unused-local-typedefs = complains about things that are defined but not used afterwards, i.e. makes development a pain in the fucking ass.
	rem incompatible-pointer-types = makes function pointers a pain in the ass since you won't be able to auto-cast "void" function pointers. Supposedly function pointers aren't always the same size so maybe this shouldn't be disabled.
	rem stringop-overflow = buggy piece of shit that incorrectly throws an error about "buffer overflows" that don't actually overflow.
	set errorflags=-Werror -Wall -Wstrict-prototypes -Wreturn-type -Winline -Wimplicit-fallthrough   -Wno-format -Wno-pointer-arith -Wno-dangling-else   -Wno-unused-function -Wno-unused-value -Wno-unused-variable -Wno-unused-but-set-variable -Wno-unused-local-typedefs -Wno-stringop-overflow
	
	set compile=%gcc% -m64
	set link=%gcc% -mconsole
	
	IF %build_type%==%build_release% (
		rem -Os turns on optimizations.
		set compile=%compile% -s -Wl,--gc-sections -DBUILD_RELEASE -Ofast
		set link=%link% -s -Wl,--gc-sections
		rem set compile=%compile% -DBUILD_RELEASE -Os
		rem -Wl,--gc-sections removes unused symbols or something from the program
		rem -mconsole and -mwindows decides what kind of executable to make, Windows has 2 different kinds, -mconsole is default. -mwindows will prevent console from opening.
		rem -s removes some symbol information that reduces the filesize by a lot
	) ELSE (
		set compile=%compile% -DBUILD_DEV
	)
	IF %build_type%==%build_debug% (
		rem -Og enables optimizations that do not interfere with debugging
		rem -g adds debug info for debuggers		-ggdb is an extended version of -g for gdb?
		set compile=%compile% -DBUILD_DEBUG -Og -ggdb
	)
	
	set compile=%compile% %errorflags% -DOS_WINDOWS -DBUILD_64BIT -c "code\main.c" -I"code" -o "main.o"
	set link=%link% "main.o" -o "%exename%.exe"

rem Build.

	echo ---Build--- Navigating... cd "%~dp0"
	cd "%~dp0"
	
	echo ---Build--- Compiling... %compile%
	%compile% || pause
	
	echo ---Build--- Linking... %link%
	%link% || pause
	
	DEL "%~dp0main.o"
	
	echo ---Build--- Done.
