#pragma once

	#ifndef BUILD_DEV
		#define BUILD_DEV 0
	#endif
	#ifndef BUILD_RELEASE
		#define BUILD_RELEASE 0
	#endif
	#ifndef BUILD_DEBUG
		#define BUILD_DEBUG 0
	#endif
	
	// ints
	typedef signed char			i8;
	typedef signed short		i16;
	typedef signed int			i32;
	typedef signed long long	i64;
	typedef unsigned char		u8;
	typedef unsigned short		u16;
	typedef unsigned int		u32;
	typedef unsigned long long	u64;
	// floats
	typedef float				f32;
	typedef double				f64;
	// bool
	typedef _Bool				bool;
	typedef unsigned char		bool8;
	typedef unsigned short		bool16;
	typedef unsigned int		bool32;
	typedef unsigned long long	bool64;
	#define true ((_Bool)1)
	#define false ((_Bool)0)
	// pointers
	typedef void (*Functionpointer) (void);
	#ifdef BUILD_64BIT
		typedef signed long long   Pointer_sized_int;
		typedef unsigned long long Pointer_sized_uint;
		typedef unsigned long long Errnum;
	#else
		typedef signed int         Pointer_sized_int;
		typedef unsigned int       Pointer_sized_uint;
		typedef unsigned int       Errnum;
	#endif
	#define NULL ((void*)0)
	#define ZERO(T) ((T){0})

// Values.

	// lengths
	#define U8_MAX  ((u8)0xFF) //  255
	#define I8_MAX  ((i8)0x7F) //  127
	#define I8_MIN  ((i8)0x80) // -128
	#define U16_MAX ((u16)0xFFFF) //  65535
	#define I16_MAX ((i16)0x7FFF) //  32767
	#define I16_MIN ((i16)0x8000) // -32768
	#define U32_MAX ((u32)0xFFFFFFFF) //  4294967295
	#define I32_MAX ((i32)0x7FFFFFFF) //  2147483647
	#define I32_MIN ((i32)0x80000000) // -2147483648
	#define U64_MAX ((u64)0xFFFFFFFFFFFFFFFF) // 18446744073709551615
	#define I64_MAX ((i64)0x7FFFFFFFFFFFFFFF) //  9223372036854775807
	#define I64_MIN ((i64)0x8000000000000000) // -9223372036854775808

// Better C.

	#define fallthrough __attribute__((fallthrough)) // you need to use this in order to fall through in switch cases. Requires -Wimplicit-fallthrough option.
	#define countof(a) (sizeof(a)/sizeof(*(a)))
		
	typedef struct {
		i64 length;
		char* data;
	} String;
	
	#define string_inline(str)          {.length=strlen(str),.data=(str)}
	#define string(str)        ((String){.length=strlen(str),.data=(str)})
	
	#define strings_are_equal(a, b) ((a).length==(b).length && mem_is_equal((a).data, (b).length, (b).data))

// Stuff

	#include <string.h>
	#include <math.h>
	#include <stdio.h>
	
	#define _ARG_COUNT(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, ...) a15
	#define ARG_COUNT(...) _ARG_COUNT(dummy, ## __VA_ARGS__, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0)
	
	typedef struct {int xxx;} NO_ARG;
	#define _ARG_1(a1, ...) a1
	#define _ARG_2(a1, a2, ...) a2
	#define _ARG_3(a1, a2, a3, ...) a3
	#define _ARG_4(a1, a2, a3, a4, ...) a4
	#define _ARG_5(a1, a2, a3, a4, a5, ...) a5
	#define _ARG_6(a1, a2, a3, a4, a5, a6, ...) a6
	#define _ARG_7(a1, a2, a3, a4, a5, a6, a7, ...) a7
	#define _ARG_8(a1, a2, a3, a4, a5, a6, a7, a, ...) a8
	#define _ARG_9(a1, a2, a3, a4, a5, a6, a7, a8, a9, ...) a9
	#define ARG_1(...) _ARG_1(__VA_ARGS__, (NO_ARG){0})
	#define ARG_2(...) _ARG_2(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_3(...) _ARG_3(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_4(...) _ARG_4(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_5(...) _ARG_5(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_6(...) _ARG_6(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_7(...) _ARG_7(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_8(...) _ARG_8(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	#define ARG_9(...) _ARG_9(__VA_ARGS__, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0}, (NO_ARG){0})
	
	#define lprintf(...)			do{printf("[%s:%i] ", __func__, __LINE__); printf(__VA_ARGS__);}while(0)
	#if BUILD_DEV || BUILD_DEBUG
		#define  printf_dev(...)	do{printf(__VA_ARGS__);}while(0)
		#define lprintf_dev(...)	do{printf("[%s:%i]\n -> ",__func__,__LINE__); printf(__VA_ARGS__);}while(0)
		#define  printf_error(...)	do{printf("* ERROR * "); printf(__VA_ARGS__);}while(0)
		#define lprintf_error(...)	do{printf("* ERROR * "); printf("[%s:%i]\n -> ",__func__,__LINE__); printf(__VA_ARGS__);}while(0)
	#else
		#define  printf_dev(...)	do{}while(0)
		#define lprintf_dev(...)	do{}while(0)
		#define  printf_error(...)	do{}while(0)
		#define lprintf_error(...)	do{}while(0)
	#endif
	
	#define ASSERT(x)		do{}while(0)
	#define ASSERTP(x, ...)	do{}while(0)
	#define START {
	#define END }
	#define RETURN(...) return __VA_ARGS__

// Includes

	static inline void mem_copy (void* target, u64 bytecount, void* source) {
		memcpy(target, source, bytecount);
	}
	static inline void mem_move (void* target, u64 bytecount, void* source) {
		memmove(target, source, bytecount);
	}
	static inline void mem_zero (u64 bytecount, void* target) {
		memset(target, 0, bytecount);
	}
	static inline bool mem_is_equal (void* target, u64 bytecount, void* source) {
		return (memcmp(target, source, bytecount)) ? false : true;
	}
	static inline void mem_set_bytes (u64 bytecount, void* target, u8 byte) {
		memset(target, byte, bytecount);
	}
	static inline bool has_zero_byte_u64 (u64 x) {
		return ((x - 0x0101010101010101) & ~x & 0x8080808080808080) ? true : false;
	}
	static inline u64 nearest_power_of_two_not_lower_u64 (u64 x) {
		// if (x == 0 || x == 1) return 1;
		// x -= 1;
		// x |= x>>1;
		// x |= x>>2;
		// x |= x>>4;
		// x |= x>>8;
		// x |= x>>16;
		// x |= x>>32;
		// return x+1;
		
		return (x == 1) ? (1) : (1 << (64 - __builtin_clzll(x-1)));
	}
	static inline u32 nearest_power_of_two_not_lower_u32 (u32 x) {
		// if (x == 0 || x == 1) return 1;
		// x -= 1;
		// x |= x>>1;
		// x |= x>>2;
		// x |= x>>4;
		// x |= x>>8;
		// x |= x>>16;
		// return x+1;
		
		return (x == 1) ? (1) : (1 << (32 - __builtin_clz(x-1)));
	}
	static inline u32 nearest_power_of_two_not_lower_u16 (u16 x) {
		// if (x == 0 || x == 1) return 1;
		// x -= 1;
		// x |= x>>1;
		// x |= x>>2;
		// x |= x>>4;
		// x |= x>>8;
		// return x+1;
		
		return (x == 1) ? (1) : (1 << (16 - __builtin_clz(x-1)));
	}
	static inline u32 nearest_power_of_two_not_lower_u8 (u8 x) {
		// if (x == 0 || x == 1) return 1;
		// x -= 1;
		// x |= x>>1;
		// x |= x>>2;
		// x |= x>>4;
		// return x+1;
		
		return (x == 1) ? (1) : (1 << (8 - __builtin_clz(x-1)));
	}
	
	static i64 string_from_u64 (char* c, u64 value) {
		if (value == 0) {
			*c = '0';
			return 1;
		}
		
		i64 digits = 0;
		u64 d = value;
		while (d) {
			d /= 10;
			digits ++;
		}
		c += digits;
		c--;
		for (i64 i=0; i<digits; i++) {
			*c = (value%10llu)+'0'; // Note: supposedly compilers recognize when modulo and divison are used in the same place, and can optimize it into a single instruction. Therefore I won't "optimize" this by using division and multiply instead of division and modulo.
			c --;
			value /= 10llu;
		}
		
		return digits;
	}
	#define INLINE_STRING_FROM_U64(n, value) char n[21]; i64 n##_length = string_from_u64(n, value); n[n##_length] = 0;
	
	static i64 string_from_i64 (char* c, i64 value) {
		if (value == 0) {
			*c = '0';
			return 1;
		}
		
		i64 length = 0;
		i64 digits = 0;
		if (value < 0) {
			value = -value;
			*c = '-';
			c++;
			length ++;
		}
		i64 d = value;
		while (d) {
			d /= 10ll;
			digits ++;
		}
		c += digits;
		c--;
		for (int i=0; i<digits; i++) {
			*c = (value%10ll)+'0'; // Note: supposedly compilers recognize when modulo and divison are used in the same place, and can optimize it into a single instruction. Therefore I won't "optimize" this by using division and multiply instead of division and modulo.
			c --;
			value /= 10ll;
		}
		
		return length + digits;
	}
	#define INLINE_STRING_FROM_I64(n, value) char n[21]; i64 n##_length = string_from_i64(n, value); n[n##_length] = 0;
	
	static i64 string_from_i64_force (char* c, i64 value, i64 forcedigits, char forcechar) {
		if (value == 0) {
			*c = '0';
			return 1;
		}
		
		i64 length = 0;
		i64 digits = 0;
		if (value < 0) {
			value = -value;
			*c = '-';
			c ++;
			forcedigits --;
			length ++;
		}
		i64 d = value;
		while (d) {
			d /= 10ll;
			digits ++;
		}
		for (i64 i=0; i<forcedigits-digits; i++) {
			*c = forcechar;
			c ++;
			length ++;
		}
		c += digits;
		c --;
		for (i64 i=0; i<digits; i++) {
			*c = (value%10ll)+'0'; // Note: supposedly compilers recognize when modulo and divison are used in the same place, and can optimize it into a single instruction. Therefore I won't "optimize" this by using division and multiply instead of division and modulo.
			c --;
			value /= 10ll;
		}
		
		return length + digits;
	}
	#define INLINE_STRING_FROM_I64_FORCE(n, value, forcedigits, forcechar) char n[21]; i64 n##_length = string_from_i64_force(n, value, forcedigits, forcechar); n[n##_length] = 0;
	
	#define STB_SPRINTF_IMPLEMENTATION
	#define STB_SPRINTF_STATIC
	#include "stb_sprintf.h"
	
	#include "windows.c"
	#include "mfstr.c"
	#include "mfarr.c"
	#include "vmem.c"
