
	#define TMFARR(T) { i64 count; T* data; i64 maxcount; }
	
	#define tmfarr_new(Name, min_count) ( (union{Name t; Mfarr m;}) mfarr_new(sizeof(*((Name*)NULL)->data), min_count) ).t
	#define tmfarr_free(a) mfarr_free((Mfarr*)(a))
	#define tmfarr_expand_to(a, destmaxcount) mfarr_expand_to((Mfarr*)(a), sizeof(*(a)->data), destmaxcount)
	#define tmfarr_append(a, item) mfarr_append((__builtin_types_compatible_p(typeof(item),typeof(NULL)) || __builtin_types_compatible_p(typeof(item),typeof((a)->data))) ? (Mfarr*)(a) : NULL, sizeof(*(a)->data), (item))

// Type

	typedef struct {
		i64 count; // how many items the array contains
		void* data;
		i64 maxcount; // how many items there's memory for
	} Mfarr;

// Manage.

	static Mfarr mfarr_new (i64 itemsize, i64 count) {
		ASSERT(itemsize > 0);
		ASSERT(count > 0);
		
		Mfarr a = {0};
		a.count = 0;
		a.maxcount = count;
		a.data = os_mem_alloc(itemsize*count);
		if (!a.data) {
			#if !BUILD_RELEASE
				lprintf_error("Ohhhh shit failed to allocate array!\n");
			#endif
			return (Mfarr){0};
		}
		
		return a;
	}
	static inline void mfarr_free (Mfarr* a) {
		if (!a) return;
		if (a->data) os_mem_free(a->data);
		*a = (Mfarr){0};
	}
	static void mfarr_expand_to (Mfarr* a, i64 itemsize, i64 destmaxcount) {
		ASSERT(a && a->data && itemsize > 0);
		ASSERT(destmaxcount > 0);
		
		if (a->maxcount >= destmaxcount) return;
		
		#if !BUILD_RELEASE
			lprintf("Mfarr reallocated %i -> ~%i. ", a->maxcount, destmaxcount);
		#endif
		
		while (a->maxcount < destmaxcount) {
			a->maxcount *= 2;
		}
		a->data = os_mem_realloc(a->data, a->maxcount*itemsize);
		
		if (!a->data) {
			#if !BUILD_RELEASE
				lprintf_error("Ohhhh shit failed to reallocate array!\n");
			#endif
			*a = (Mfarr){0};
			return;
		}
	}
	static void* mfarr_append (Mfarr* a, i64 itemsize, void* newdata) {
		ASSERT(a && a->data && itemsize > 0);
		
		if (a->maxcount < a->count+1) {
			mfarr_expand_to(a, itemsize, a->count+1);
			if (!a->data) return NULL;
		}
		
		if (newdata) {
			mem_copy(
				a->data+(a->count*itemsize),
				itemsize,
				newdata
			);
		}
		a->count ++;
		
		return a->data + (itemsize*(a->count-1));
	}
