/*
	Predefined types:
		Unsigned integers:
			u8 = unsigned char
			u16 = unsigned short
			u32 = unsigned int
			u64 = unsigned long long
			u24 = 3-byte unsigned integer
			u40 = 5-byte unsigned integer
			u48 = 6-byte unsigned integer
			u56 = 7-byte unsigned integer
		Signed integers:
			i8 = char
			i16 = short
			i32 = int
			i64 = long long
			i24 = 3-byte integer
			i40 = 5-byte integer
			i48 = 6-byte integer
			i56 = 7-byte integer
		Floating point:
			f16 = half float
			f32 = float
			f64 = double
	
	Syntax:
		struct Name {
			u32 membername1;
			u32 membername2;
		}
		
		union Name {
			u32 membername1;
			u32 membername2;
		}
		
		// Both comma and semicolon will work.
		enum Name u32 {
			membername1,
			membername2,
		}
		
		typedef Name u32;
	
	NOTE: Types must be defined sequentially, and you cannot forward-declare a type.
	NOTE: An infinite loop may occur if a struct member leads to itself. That isn't possible in code, so I didn't bother checking for it here either.
	
	TODO:
		- Arrays (including empty ones?).
		- Anonymous structs and unions.
		- Booleans / bitfields / some non-byte-sized alignment method.
		- Pointers..? They're probably useless for files, but a struct may in theory have one and it would be annoying if you had to fix them instead of just copy pasting the struct to this file as-is. Problem is that they don't have a consistent size.
		- 'char' type? u8 that shows as a character rather than the integer value.
*/

struct Ico_file_header {
	u16 _reserved; // Must be 0.
	u16 type; // 1 = ico, 2 = cur
	u16 image_count; // Number of images.
};
struct Ico_image_header {
	u8 width; // note: 0 means 256
	u8 height;
	u8 palette_size; // 0 if no palette
	u8 _reserved;
	u16 color_planes; // For ico files. 0 or 1.
	u16 bits_per_pixel; // For ico files. 0 or 1.
	u32 data_size;
	u32 data_offset; // image data starts from here, offset from the beginning of the entire file.
};
struct Cur_image_header {
	u8 width; // note: 0 means 256
	u8 height;
	u8 palette_size; // 0 if no palette
	u8 _reserved;
	u16 hotspot_x; // For cur files.
	u16 hotspot_y; // For cur files.
	u32 data_size;
	u32 data_offset; // image data starts from here, offset from the beginning of the entire file.
};
enum BMPCOMP u32 {
	BMPCOMP_RGB,
	BMPCOMP_RLE8,
	BMPCOMP_RLE4,
	BMPCOMP_BITFIELDS,
	BMPCOMP_JPEG,
	BMPCOMP_PNG,
};
struct CIEXYZ {
	i32 X;
	i32 Y;
	i32 Z;
};
struct CIEXYZTRIPLE {
	CIEXYZ Red;
	CIEXYZ Green;
	CIEXYZ Blue;
};
struct Bmp_fileheader {
	// char filetype [2];
	u8 filetype_1;
	u8 filetype_2;
	u32 filesize;
	u16 reserved1;
	u16 reserved2;
	u32 pixeldataoffset;
};
struct Bmp_imageheader_40 {
	u32 headersize; // DWORD Size
	i32 width; // LONG Width
	i32 height; // LONG Height // If negative, pixel data is read from top to bottom. Otherwise it's bottom to top.
	u16 colorplanes; // WORD Planes // Must be 1.
	u16 bitsperpixel; // WORD BitCount // Typical values are 1, 4, 8, 16, 24 and 32.
	u32 compression; // DWORD Compression // 0 for no compression. 3 if using the bit masks.
	u32 imagesize; // DWORD SizeImage // Can be 0 if no compression. Seems to also be fine as 0 if using bit masks.
	i32 pixelspermeterx; // LONG XPelsPerMeter
	i32 pixelspermetery; // LONG YPelsPerMeter
	u32 colormapcolorcount; // DWORD ClrUsed
	u32 importantcolorcount; // DWORD ClrImportant
};
struct Bmp_imageheader_108 { // BITMAPV4HEADER
	Bmp_imageheader_40 bmp40;
	u32 bitmaskred; // DWORD RedMask
	u32 bitmaskgreen; // DWORD GreenMask
	u32 bitmaskblue; // DWORD BlueMask
	u32 bitmaskalpha; // DWORD AlphaMask
	u32 colorspace; // DWORD CSType
	CIEXYZTRIPLE endpoints; // CIEXYZTRIPLE Endpoints
	u32 gammared; // DWORD GammaRed
	u32 gammagreen; // DWORD GammaGreen
	u32 gammablue; // DWORD GammaBlue
};
struct Bmp_imageheader_124 { // BITMAPV5HEADER
	Bmp_imageheader_108 bmp108;
	u32 intent; // DWORD xxx
	u32 profiledata; // DWORD xxx
	u32 profilesize; // DWORD xxx
	u32 _reserved; // DWORD xxx
};

// typedef WORD u16;
// typedef DWORD u32;
// typedef LONG i32;
// struct BITMAPV5HEADER {
// 	DWORD        bV5Size;
// 	LONG         bV5Width;
// 	LONG         bV5Height;
// 	WORD         bV5Planes;
// 	WORD         bV5BitCount;
// 	DWORD        bV5Compression;
// 	DWORD        bV5SizeImage;
// 	LONG         bV5XPelsPerMeter;
// 	LONG         bV5YPelsPerMeter;
// 	DWORD        bV5ClrUsed;
// 	DWORD        bV5ClrImportant;
// 	DWORD        bV5RedMask;
// 	DWORD        bV5GreenMask;
// 	DWORD        bV5BlueMask;
// 	DWORD        bV5AlphaMask;
// 	DWORD        bV5CSType;
// 	CIEXYZTRIPLE bV5Endpoints;
// 	DWORD        bV5GammaRed;
// 	DWORD        bV5GammaGreen;
// 	DWORD        bV5GammaBlue;
// 	DWORD        bV5Intent;
// 	DWORD        bV5ProfileData;
// 	DWORD        bV5ProfileSize;
// 	DWORD        bV5Reserved;
// };